

CREATE TABLE `ml_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ml_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ml_itsec_distributed_storage` (
  `storage_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_key` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `storage_chunk` int(11) NOT NULL DEFAULT '0',
  `storage_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ml_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=InnoDB AUTO_INCREMENT=1414 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO ml_itsec_lockouts VALUES("1412","brute_force","2022-03-28 06:31:06","2022-03-28 10:31:06","2022-03-28 06:46:06","2022-03-28 10:46:06","54.245.159.92","","","1");
INSERT INTO ml_itsec_lockouts VALUES("1413","brute_force","2022-04-03 04:34:57","2022-04-03 08:34:57","2022-04-03 04:49:57","2022-04-03 08:49:57","2.58.149.155","","","1");



CREATE TABLE `ml_itsec_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint(20) unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint(20) unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35275 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO ml_itsec_logs VALUES("34036","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54893\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"212.192.246.199\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"484\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643876628.8126\";s:12:\"REQUEST_TIME\";s:10:\"1643876628\";}}","notice","2022-02-03 08:23:49","2022-02-03 08:23:48","7062336","7127328","https://messagetech.com//xmlrpc.php","1","0","212.192.246.199");
INSERT INTO ml_itsec_logs VALUES("34037","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55510\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"212.192.246.199\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643876630.4843\";s:12:\"REQUEST_TIME\";s:10:\"1643876630\";}}","notice","2022-02-03 08:23:50","2022-02-03 08:23:50","7062336","7127328","https://messagetech.com//xmlrpc.php","1","0","212.192.246.199");
INSERT INTO ml_itsec_logs VALUES("34038","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55927\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"212.192.246.199\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:12:\"1643876631.8\";s:12:\"REQUEST_TIME\";s:10:\"1643876631\";}}","notice","2022-02-03 08:23:51","2022-02-03 08:23:51","7062344","7127336","https://messagetech.com//xmlrpc.php","1","0","212.192.246.199");
INSERT INTO ml_itsec_logs VALUES("34039","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56383\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"212.192.246.199\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643876633.1824\";s:12:\"REQUEST_TIME\";s:10:\"1643876633\";}}","notice","2022-02-03 08:23:54","2022-02-03 08:23:53","7062344","7127336","https://messagetech.com//xmlrpc.php","1","0","212.192.246.199");
INSERT INTO ml_itsec_logs VALUES("34040","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57212\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"212.192.246.199\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"492\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643876635.6829\";s:12:\"REQUEST_TIME\";s:10:\"1643876635\";}}","notice","2022-02-03 08:23:56","2022-02-03 08:23:55","7062472","7127464","https://messagetech.com//xmlrpc.php","1","0","212.192.246.199");
INSERT INTO ml_itsec_logs VALUES("34041","0","lockout","host-lockout::212.192.246.199","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:15:\"212.192.246.199\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-03 03:23:55\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-03 08:23:55\";s:14:\"lockout_expire\";s:19:\"2022-02-03 03:38:55\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-03 08:38:55\";s:12:\"lockout_host\";s:15:\"212.192.246.199\";}","action","2022-02-03 08:23:56","2022-02-03 08:23:55","7106656","7134264","https://messagetech.com//xmlrpc.php","1","0","212.192.246.199");
INSERT INTO ml_itsec_logs VALUES("34042","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"23674\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.253\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643886348.0227\";s:12:\"REQUEST_TIME\";s:10:\"1643886348\";}}","notice","2022-02-03 11:05:48","2022-02-03 11:05:48","7045184","7094768","https://messagetech.com/xmlrpc.php","1","0","185.220.100.253");
INSERT INTO ml_itsec_logs VALUES("34043","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50144\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"143.198.222.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"489\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643889855.4412\";s:12:\"REQUEST_TIME\";s:10:\"1643889855\";}}","notice","2022-02-03 12:04:15","2022-02-03 12:04:15","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","143.198.222.240");
INSERT INTO ml_itsec_logs VALUES("34044","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52422\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"143.198.222.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643889857.6732\";s:12:\"REQUEST_TIME\";s:10:\"1643889857\";}}","notice","2022-02-03 12:04:19","2022-02-03 12:04:17","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","143.198.222.240");
INSERT INTO ml_itsec_logs VALUES("34045","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55120\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"143.198.222.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643889860.3924\";s:12:\"REQUEST_TIME\";s:10:\"1643889860\";}}","notice","2022-02-03 12:04:20","2022-02-03 12:04:20","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","143.198.222.240");
INSERT INTO ml_itsec_logs VALUES("34046","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56263\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"143.198.222.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"481\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1643889861.646\";s:12:\"REQUEST_TIME\";s:10:\"1643889861\";}}","notice","2022-02-03 12:04:21","2022-02-03 12:04:21","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","143.198.222.240");
INSERT INTO ml_itsec_logs VALUES("34047","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57508\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"143.198.222.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643889862.8929\";s:12:\"REQUEST_TIME\";s:10:\"1643889862\";}}","notice","2022-02-03 12:04:22","2022-02-03 12:04:22","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","143.198.222.240");
INSERT INTO ml_itsec_logs VALUES("34048","0","lockout","host-lockout::143.198.222.240","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:15:\"143.198.222.240\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-03 07:04:22\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-03 12:04:22\";s:14:\"lockout_expire\";s:19:\"2022-02-03 07:19:22\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-03 12:19:22\";s:12:\"lockout_host\";s:15:\"143.198.222.240\";}","action","2022-02-03 12:04:22","2022-02-03 12:04:22","7106568","7134176","https://www.messagetech.com//xmlrpc.php","1","0","143.198.222.240");
INSERT INTO ml_itsec_logs VALUES("34049","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53054\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"89.58.17.76\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:77:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:84.0) Gecko/20100101 Firefox/84.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643904245.7578\";s:12:\"REQUEST_TIME\";s:10:\"1643904245\";}}","notice","2022-02-03 16:04:05","2022-02-03 16:04:05","7048312","7101120","https://messagetech.com/xmlrpc.php","1","0","89.58.17.76");
INSERT INTO ml_itsec_logs VALUES("34050","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1408\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"20.101.106.180\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643912735.7164\";s:12:\"REQUEST_TIME\";s:10:\"1643912735\";}}","notice","2022-02-03 18:25:35","2022-02-03 18:25:35","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","20.101.106.180");
INSERT INTO ml_itsec_logs VALUES("34051","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1409\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"20.101.106.180\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643912736.8381\";s:12:\"REQUEST_TIME\";s:10:\"1643912736\";}}","notice","2022-02-03 18:25:36","2022-02-03 18:25:36","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","20.101.106.180");
INSERT INTO ml_itsec_logs VALUES("34052","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1410\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"20.101.106.180\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643912737.9295\";s:12:\"REQUEST_TIME\";s:10:\"1643912737\";}}","notice","2022-02-03 18:25:37","2022-02-03 18:25:37","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","20.101.106.180");
INSERT INTO ml_itsec_logs VALUES("34053","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1411\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"20.101.106.180\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643912739.0089\";s:12:\"REQUEST_TIME\";s:10:\"1643912739\";}}","notice","2022-02-03 18:25:39","2022-02-03 18:25:39","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","20.101.106.180");
INSERT INTO ml_itsec_logs VALUES("34054","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1412\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"20.101.106.180\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"481\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643912740.0703\";s:12:\"REQUEST_TIME\";s:10:\"1643912740\";}}","notice","2022-02-03 18:25:40","2022-02-03 18:25:40","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","20.101.106.180");
INSERT INTO ml_itsec_logs VALUES("34055","0","lockout","host-lockout::20.101.106.180","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:14:\"20.101.106.180\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-03 13:25:40\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-03 18:25:40\";s:14:\"lockout_expire\";s:19:\"2022-02-03 13:40:40\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-03 18:40:40\";s:12:\"lockout_host\";s:14:\"20.101.106.180\";}","action","2022-02-03 18:25:41","2022-02-03 18:25:40","7106568","7134176","https://www.messagetech.com//xmlrpc.php","1","0","20.101.106.180");
INSERT INTO ml_itsec_logs VALUES("34056","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52752\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"158.69.63.54\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:109:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643950201.5678\";s:12:\"REQUEST_TIME\";s:10:\"1643950201\";}}","notice","2022-02-04 04:50:01","2022-02-04 04:50:01","7058976","7123968","https://faq.messagetech.com/xmlrpc.php","1","0","158.69.63.54");
INSERT INTO ml_itsec_logs VALUES("34057","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"7780\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.101.139\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:126:\"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36 OPR/75.0.3969.141\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643953408.9591\";s:12:\"REQUEST_TIME\";s:10:\"1643953408\";}}","notice","2022-02-04 05:43:29","2022-02-04 05:43:28","7073328","7138320","https://messagetech.com/xmlrpc.php","1","0","185.220.101.139");
INSERT INTO ml_itsec_logs VALUES("34058","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50607\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"52.140.196.12\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1643961248.525\";s:12:\"REQUEST_TIME\";s:10:\"1643961248\";}}","notice","2022-02-04 07:54:08","2022-02-04 07:54:08","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","52.140.196.12");
INSERT INTO ml_itsec_logs VALUES("34059","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50775\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"52.140.196.12\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643961249.3639\";s:12:\"REQUEST_TIME\";s:10:\"1643961249\";}}","notice","2022-02-04 07:54:09","2022-02-04 07:54:09","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","52.140.196.12");
INSERT INTO ml_itsec_logs VALUES("34060","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50953\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"52.140.196.12\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1643961250.181\";s:12:\"REQUEST_TIME\";s:10:\"1643961250\";}}","notice","2022-02-04 07:54:10","2022-02-04 07:54:10","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","52.140.196.12");
INSERT INTO ml_itsec_logs VALUES("34061","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51195\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"52.140.196.12\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643961251.3533\";s:12:\"REQUEST_TIME\";s:10:\"1643961251\";}}","notice","2022-02-04 07:54:11","2022-02-04 07:54:11","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","52.140.196.12");
INSERT INTO ml_itsec_logs VALUES("34062","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51360\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"52.140.196.12\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643961252.1616\";s:12:\"REQUEST_TIME\";s:10:\"1643961252\";}}","notice","2022-02-04 07:54:12","2022-02-04 07:54:12","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","52.140.196.12");
INSERT INTO ml_itsec_logs VALUES("34063","0","lockout","host-lockout::52.140.196.12","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:13:\"52.140.196.12\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-04 02:54:12\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-04 07:54:12\";s:14:\"lockout_expire\";s:19:\"2022-02-04 03:09:12\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-04 08:09:12\";s:12:\"lockout_host\";s:13:\"52.140.196.12\";}","action","2022-02-04 07:54:12","2022-02-04 07:54:12","7106576","7134184","https://www.messagetech.com//xmlrpc.php","1","0","52.140.196.12");
INSERT INTO ml_itsec_logs VALUES("34064","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"25090\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.46\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:55.0) Gecko/20100101 Firefox/55.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1643984442.433\";s:12:\"REQUEST_TIME\";s:10:\"1643984442\";}}","notice","2022-02-04 14:20:42","2022-02-04 14:20:42","7073328","7138304","https://client.messagetech.com/xmlrpc.php","1","0","185.220.101.46");
INSERT INTO ml_itsec_logs VALUES("34065","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57328\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"51.15.7.157\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1643992900.3341\";s:12:\"REQUEST_TIME\";s:10:\"1643992900\";}}","notice","2022-02-04 16:41:40","2022-02-04 16:41:40","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","51.15.7.157");
INSERT INTO ml_itsec_logs VALUES("34066","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"26420\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.79\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644028543.0212\";s:12:\"REQUEST_TIME\";s:10:\"1644028543\";}}","notice","2022-02-05 02:35:43","2022-02-05 02:35:43","7045184","7094768","https://messagetech.com/xmlrpc.php","1","0","185.220.101.79");
INSERT INTO ml_itsec_logs VALUES("34067","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"18918\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.101.172\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:68:\"Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644031522.3935\";s:12:\"REQUEST_TIME\";s:10:\"1644031522\";}}","notice","2022-02-05 03:25:22","2022-02-05 03:25:22","7058848","7123840","https://blog.messagetech.com/xmlrpc.php","1","0","185.220.101.172");
INSERT INTO ml_itsec_logs VALUES("34068","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"8554\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.255\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:84.0) Gecko/20100101 Firefox/84.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644043995.8305\";s:12:\"REQUEST_TIME\";s:10:\"1644043995\";}}","notice","2022-02-05 06:53:15","2022-02-05 06:53:15","7048312","7101120","https://messagetech.com/xmlrpc.php","1","0","185.220.100.255");
INSERT INTO ml_itsec_logs VALUES("34069","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"38726\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"199.249.230.151\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36 OPR/75.0.3969.149\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644092199.4729\";s:12:\"REQUEST_TIME\";s:10:\"1644092199\";}}","notice","2022-02-05 20:16:39","2022-02-05 20:16:39","7073328","7138320","https://messagetech.com/xmlrpc.php","1","0","199.249.230.151");
INSERT INTO ml_itsec_logs VALUES("34070","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"2165\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"198.98.59.35\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644112915.9871\";s:12:\"REQUEST_TIME\";s:10:\"1644112915\";}}","notice","2022-02-06 02:01:56","2022-02-06 02:01:56","7058976","7123968","https://faq.messagetech.com/xmlrpc.php","1","0","198.98.59.35");
INSERT INTO ml_itsec_logs VALUES("34071","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:9:\"dev_admin\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"64539\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"488\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644114503.0962\";s:12:\"REQUEST_TIME\";s:10:\"1644114503\";}}","notice","2022-02-06 02:28:23","2022-02-06 02:28:23","7026248","7072440","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34072","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:9:\"dev_admin\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50689\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"489\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644114504.7041\";s:12:\"REQUEST_TIME\";s:10:\"1644114504\";}}","notice","2022-02-06 02:28:25","2022-02-06 02:28:24","7026248","7072440","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34073","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:9:\"dev_admin\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54716\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644114507.2581\";s:12:\"REQUEST_TIME\";s:10:\"1644114507\";}}","notice","2022-02-06 02:28:28","2022-02-06 02:28:27","7026248","7072440","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34074","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:9:\"dev_admin\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58350\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"491\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644114509.4524\";s:12:\"REQUEST_TIME\";s:10:\"1644114509\";}}","notice","2022-02-06 02:28:29","2022-02-06 02:28:29","7026384","7072576","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34075","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:9:\"dev_admin\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60033\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"491\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644114510.8032\";s:12:\"REQUEST_TIME\";s:10:\"1644114510\";}}","notice","2022-02-06 02:28:30","2022-02-06 02:28:30","7026384","7072576","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34076","0","lockout","host-lockout::45.95.169.230","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:13:\"45.95.169.230\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-05 21:28:30\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-06 02:28:30\";s:14:\"lockout_expire\";s:19:\"2022-02-05 21:43:30\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-06 02:43:30\";s:12:\"lockout_host\";s:13:\"45.95.169.230\";}","action","2022-02-06 02:28:30","2022-02-06 02:28:30","7070568","7098176","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34077","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"10478\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.249\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:78:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644144389.3898\";s:12:\"REQUEST_TIME\";s:10:\"1644144389\";}}","notice","2022-02-06 10:46:29","2022-02-06 10:46:29","7058928","7123904","https://client.messagetech.com/xmlrpc.php","1","0","185.220.102.249");
INSERT INTO ml_itsec_logs VALUES("34078","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41166\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"94.230.208.147\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Safari/605.1.15\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644152621.1306\";s:12:\"REQUEST_TIME\";s:10:\"1644152621\";}}","notice","2022-02-06 13:03:41","2022-02-06 13:03:41","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","94.230.208.147");
INSERT INTO ml_itsec_logs VALUES("34079","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"46529\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"89.234.157.254\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.101 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644166578.725\";s:12:\"REQUEST_TIME\";s:10:\"1644166578\";}}","notice","2022-02-06 16:56:18","2022-02-06 16:56:18","7045184","7094768","https://messagetech.com/xmlrpc.php","1","0","89.234.157.254");
INSERT INTO ml_itsec_logs VALUES("34080","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41328\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"185.117.215.9\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:77:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:84.0) Gecko/20100101 Firefox/84.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644182187.4087\";s:12:\"REQUEST_TIME\";s:10:\"1644182187\";}}","notice","2022-02-06 21:16:27","2022-02-06 21:16:27","7048312","7101120","https://messagetech.com/xmlrpc.php","1","0","185.117.215.9");
INSERT INTO ml_itsec_logs VALUES("34081","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33517\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"185.129.61.3\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/11.1 Safari/605.1.15\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644191210.1022\";s:12:\"REQUEST_TIME\";s:10:\"1644191210\";}}","notice","2022-02-06 23:46:50","2022-02-06 23:46:50","7058976","7123968","https://blog.messagetech.com/xmlrpc.php","1","0","185.129.61.3");
INSERT INTO ml_itsec_logs VALUES("34082","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53091\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"68.183.226.92\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"484\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644216830.1316\";s:12:\"REQUEST_TIME\";s:10:\"1644216830\";}}","notice","2022-02-07 06:53:50","2022-02-07 06:53:50","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","68.183.226.92");
INSERT INTO ml_itsec_logs VALUES("34083","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54974\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"68.183.226.92\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644216831.974\";s:12:\"REQUEST_TIME\";s:10:\"1644216831\";}}","notice","2022-02-07 06:53:52","2022-02-07 06:53:52","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","68.183.226.92");
INSERT INTO ml_itsec_logs VALUES("34084","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56942\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"68.183.226.92\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644216833.9641\";s:12:\"REQUEST_TIME\";s:10:\"1644216833\";}}","notice","2022-02-07 06:53:54","2022-02-07 06:53:53","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","68.183.226.92");
INSERT INTO ml_itsec_logs VALUES("34085","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"59263\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"68.183.226.92\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644216835.9661\";s:12:\"REQUEST_TIME\";s:10:\"1644216835\";}}","notice","2022-02-07 06:53:56","2022-02-07 06:53:55","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","68.183.226.92");
INSERT INTO ml_itsec_logs VALUES("34086","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60750\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"68.183.226.92\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"488\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644216837.381\";s:12:\"REQUEST_TIME\";s:10:\"1644216837\";}}","notice","2022-02-07 06:53:57","2022-02-07 06:53:57","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","68.183.226.92");
INSERT INTO ml_itsec_logs VALUES("34087","0","lockout","host-lockout::68.183.226.92","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:13:\"68.183.226.92\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-07 01:53:57\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-07 06:53:57\";s:14:\"lockout_expire\";s:19:\"2022-02-07 02:08:57\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-07 07:08:57\";s:12:\"lockout_host\";s:13:\"68.183.226.92\";}","action","2022-02-07 06:53:57","2022-02-07 06:53:57","7106576","7134184","https://www.messagetech.com//xmlrpc.php","1","0","68.183.226.92");
INSERT INTO ml_itsec_logs VALUES("34088","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"47446\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"107.189.31.102\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:133:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36 OPR/75.0.3969.171\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644221453.4184\";s:12:\"REQUEST_TIME\";s:10:\"1644221453\";}}","notice","2022-02-07 08:10:53","2022-02-07 08:10:53","7073328","7138320","https://messagetech.com/xmlrpc.php","1","0","107.189.31.102");
INSERT INTO ml_itsec_logs VALUES("34089","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"46416\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"81.17.18.62\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:110:\"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644263149.1897\";s:12:\"REQUEST_TIME\";s:10:\"1644263149\";}}","notice","2022-02-07 19:45:49","2022-02-07 19:45:49","7058976","7123968","https://faq.messagetech.com/xmlrpc.php","1","0","81.17.18.62");
INSERT INTO ml_itsec_logs VALUES("34090","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60574\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:10:\"5.2.70.223\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:127:\"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36 OPR/73.0.3856.344\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644291335.7739\";s:12:\"REQUEST_TIME\";s:10:\"1644291335\";}}","notice","2022-02-08 03:35:36","2022-02-08 03:35:35","7045184","7094768","https://messagetech.com/xmlrpc.php","1","0","5.2.70.223");
INSERT INTO ml_itsec_logs VALUES("34091","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33350\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"213.164.204.171\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644293155.7555\";s:12:\"REQUEST_TIME\";s:10:\"1644293155\";}}","notice","2022-02-08 04:05:55","2022-02-08 04:05:55","7059024","7124000","https://client.messagetech.com/xmlrpc.php","1","0","213.164.204.171");
INSERT INTO ml_itsec_logs VALUES("34092","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53144\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"151.80.148.159\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Safari/605.1.15\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644301023.7295\";s:12:\"REQUEST_TIME\";s:10:\"1644301023\";}}","notice","2022-02-08 06:17:03","2022-02-08 06:17:03","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","151.80.148.159");
INSERT INTO ml_itsec_logs VALUES("34093","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41814\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"45.33.106.16\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:78:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644306859.1041\";s:12:\"REQUEST_TIME\";s:10:\"1644306859\";}}","notice","2022-02-08 07:54:19","2022-02-08 07:54:19","7048312","7101120","https://messagetech.com/xmlrpc.php","1","0","45.33.106.16");
INSERT INTO ml_itsec_logs VALUES("34094","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58648\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"37.120.177.0\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"225\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644309270.449\";s:12:\"REQUEST_TIME\";s:10:\"1644309270\";}}","notice","2022-02-08 08:34:30","2022-02-08 08:34:30","7073288","7138280","https://www.messagetech.com/xmlrpc.php","1","0","37.120.177.0");
INSERT INTO ml_itsec_logs VALUES("34095","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60406\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"37.120.177.0\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644309273.3082\";s:12:\"REQUEST_TIME\";s:10:\"1644309273\";}}","notice","2022-02-08 08:34:33","2022-02-08 08:34:33","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","37.120.177.0");
INSERT INTO ml_itsec_logs VALUES("34096","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34250\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"37.120.177.0\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"225\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644309275.4428\";s:12:\"REQUEST_TIME\";s:10:\"1644309275\";}}","notice","2022-02-08 08:34:35","2022-02-08 08:34:35","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","37.120.177.0");
INSERT INTO ml_itsec_logs VALUES("34097","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"21438\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.253\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"228\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644309277.5207\";s:12:\"REQUEST_TIME\";s:10:\"1644309277\";}}","notice","2022-02-08 08:34:37","2022-02-08 08:34:37","7058896","7123888","https://www.messagetech.com/xmlrpc.php","1","0","185.220.100.253");
INSERT INTO ml_itsec_logs VALUES("34098","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"46275\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.31\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644331656.4038\";s:12:\"REQUEST_TIME\";s:10:\"1644331656\";}}","notice","2022-02-08 14:47:36","2022-02-08 14:47:36","7045152","7094736","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.31");
INSERT INTO ml_itsec_logs VALUES("34099","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"44075\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.31\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644331658.2538\";s:12:\"REQUEST_TIME\";s:10:\"1644331658\";}}","notice","2022-02-08 14:47:38","2022-02-08 14:47:38","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.31");
INSERT INTO ml_itsec_logs VALUES("34100","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"40375\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.31\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"228\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644331660.0315\";s:12:\"REQUEST_TIME\";s:10:\"1644331660\";}}","notice","2022-02-08 14:47:40","2022-02-08 14:47:40","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.31");
INSERT INTO ml_itsec_logs VALUES("34101","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"46988\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"192.42.116.23\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"234\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644331662.629\";s:12:\"REQUEST_TIME\";s:10:\"1644331662\";}}","notice","2022-02-08 14:47:42","2022-02-08 14:47:42","7045216","7094800","https://www.messagetech.com/xmlrpc.php","1","0","192.42.116.23");
INSERT INTO ml_itsec_logs VALUES("34102","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52330\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:9:\"5.2.69.50\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:129:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644340728.6606\";s:12:\"REQUEST_TIME\";s:10:\"1644340728\";}}","notice","2022-02-08 17:18:48","2022-02-08 17:18:48","7058976","7123968","https://blog.messagetech.com/xmlrpc.php","1","0","5.2.69.50");
INSERT INTO ml_itsec_logs VALUES("34103","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"42756\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.165.171.40\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"235\";s:15:\"HTTP_USER_AGENT\";s:129:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 Edge/18.18363\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644344988.1437\";s:12:\"REQUEST_TIME\";s:10:\"1644344988\";}}","notice","2022-02-08 18:29:48","2022-02-08 18:29:48","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","185.165.171.40");
INSERT INTO ml_itsec_logs VALUES("34104","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"42796\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.165.171.40\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:129:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 Edge/18.18363\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644344990.542\";s:12:\"REQUEST_TIME\";s:10:\"1644344990\";}}","notice","2022-02-08 18:29:50","2022-02-08 18:29:50","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","185.165.171.40");
INSERT INTO ml_itsec_logs VALUES("34105","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"42882\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.165.171.40\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"230\";s:15:\"HTTP_USER_AGENT\";s:129:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 Edge/18.18363\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644344993.3188\";s:12:\"REQUEST_TIME\";s:10:\"1644344993\";}}","notice","2022-02-08 18:29:53","2022-02-08 18:29:53","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","185.165.171.40");
INSERT INTO ml_itsec_logs VALUES("34106","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"42960\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.165.171.40\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"238\";s:15:\"HTTP_USER_AGENT\";s:129:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 Edge/18.18363\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644344995.8572\";s:12:\"REQUEST_TIME\";s:10:\"1644344995\";}}","notice","2022-02-08 18:29:55","2022-02-08 18:29:55","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","185.165.171.40");
INSERT INTO ml_itsec_logs VALUES("34107","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"37167\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.100.87.174\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36 OPR/75.0.3969.149\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644348680.6316\";s:12:\"REQUEST_TIME\";s:10:\"1644348680\";}}","notice","2022-02-08 19:31:20","2022-02-08 19:31:20","7073328","7138320","https://messagetech.com/xmlrpc.php","1","0","185.100.87.174");
INSERT INTO ml_itsec_logs VALUES("34108","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34039\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"195.176.3.24\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644400342.3156\";s:12:\"REQUEST_TIME\";s:10:\"1644400342\";}}","notice","2022-02-09 09:52:22","2022-02-09 09:52:22","7058896","7123888","https://www.messagetech.com/xmlrpc.php","1","0","195.176.3.24");
INSERT INTO ml_itsec_logs VALUES("34109","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"13566\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.65\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"225\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644400354.9518\";s:12:\"REQUEST_TIME\";s:10:\"1644400354\";}}","notice","2022-02-09 09:52:35","2022-02-09 09:52:34","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.65");
INSERT INTO ml_itsec_logs VALUES("34110","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"12802\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.65\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644400357.2736\";s:12:\"REQUEST_TIME\";s:10:\"1644400357\";}}","notice","2022-02-09 09:52:37","2022-02-09 09:52:37","7058896","7123888","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.65");
INSERT INTO ml_itsec_logs VALUES("34111","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"38877\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"104.244.73.169\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:73:\"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:56.0) Gecko/20100101 Firefox/56.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644413323.4403\";s:12:\"REQUEST_TIME\";s:10:\"1644413323\";}}","notice","2022-02-09 13:28:43","2022-02-09 13:28:43","7058880","7123872","https://faq.messagetech.com/xmlrpc.php","1","0","104.244.73.169");
INSERT INTO ml_itsec_logs VALUES("34112","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52804\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"104.244.72.65\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.77 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644417132.2667\";s:12:\"REQUEST_TIME\";s:10:\"1644417132\";}}","notice","2022-02-09 14:32:12","2022-02-09 14:32:12","7059584","7109168","https://messagetech.com/xmlrpc.php","1","0","104.244.72.65");
INSERT INTO ml_itsec_logs VALUES("34113","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:4:\"user\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"62103\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644419545.8354\";s:12:\"REQUEST_TIME\";s:10:\"1644419545\";}}","notice","2022-02-09 15:12:25","2022-02-09 15:12:25","7026232","7072432","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34114","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:4:\"user\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"65204\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"484\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644419547.2182\";s:12:\"REQUEST_TIME\";s:10:\"1644419547\";}}","notice","2022-02-09 15:12:27","2022-02-09 15:12:27","7026232","7072432","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34115","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:4:\"user\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50760\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"482\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644419548.4833\";s:12:\"REQUEST_TIME\";s:10:\"1644419548\";}}","notice","2022-02-09 15:12:28","2022-02-09 15:12:28","7026232","7072432","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34116","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:4:\"user\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54190\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"486\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644419550.2629\";s:12:\"REQUEST_TIME\";s:10:\"1644419550\";}}","notice","2022-02-09 15:12:30","2022-02-09 15:12:30","7026240","7072440","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34117","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:162:\"<strong>ERROR</strong>: Invalid username. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:4:\"user\";s:7:\"user_id\";b:0;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57160\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.95.169.230\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:14:\"35.160.200.169\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"486\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4240.193 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:14:\"35.160.200.169\";s:11:\"SSL_TLS_SNI\";s:14:\"35.160.200.169\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:33:\"https://35.160.200.169/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644419552.1509\";s:12:\"REQUEST_TIME\";s:10:\"1644419552\";}}","notice","2022-02-09 15:12:32","2022-02-09 15:12:32","7026240","7072440","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34118","0","lockout","host-lockout::45.95.169.230","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:13:\"45.95.169.230\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-09 10:12:32\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-09 15:12:32\";s:14:\"lockout_expire\";s:19:\"2022-02-09 10:27:32\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-09 15:27:32\";s:12:\"lockout_host\";s:13:\"45.95.169.230\";}","action","2022-02-09 15:12:32","2022-02-09 15:12:32","7070424","7098032","https://35.160.200.169//xmlrpc.php","1","0","45.95.169.230");
INSERT INTO ml_itsec_logs VALUES("34119","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34259\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.103.113\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:66:\"Mozilla/5.0 (Windows NT 10.0; rv:86.0) Gecko/20100101 Firefox/86.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644433593.1242\";s:12:\"REQUEST_TIME\";s:10:\"1644433593\";}}","notice","2022-02-09 19:06:33","2022-02-09 19:06:33","7048280","7101088","https://messagetech.com/xmlrpc.php","1","0","185.220.103.113");
INSERT INTO ml_itsec_logs VALUES("34120","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"8862\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.101.178\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644445560.8044\";s:12:\"REQUEST_TIME\";s:10:\"1644445560\";}}","notice","2022-02-09 22:26:00","2022-02-09 22:26:00","7059024","7124000","https://client.messagetech.com/xmlrpc.php","1","0","185.220.101.178");
INSERT INTO ml_itsec_logs VALUES("34121","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57166\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"199.249.230.117\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"227\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644452255.0184\";s:12:\"REQUEST_TIME\";s:10:\"1644452255\";}}","notice","2022-02-10 00:17:35","2022-02-10 00:17:35","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","199.249.230.117");
INSERT INTO ml_itsec_logs VALUES("34122","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57268\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"199.249.230.117\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644452257.1824\";s:12:\"REQUEST_TIME\";s:10:\"1644452257\";}}","notice","2022-02-10 00:17:37","2022-02-10 00:17:37","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","199.249.230.117");
INSERT INTO ml_itsec_logs VALUES("34123","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57334\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"199.249.230.117\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644452259.5014\";s:12:\"REQUEST_TIME\";s:10:\"1644452259\";}}","notice","2022-02-10 00:17:39","2022-02-10 00:17:39","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","199.249.230.117");
INSERT INTO ml_itsec_logs VALUES("34124","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"35584\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:9:\"5.2.69.50\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644452262.3904\";s:12:\"REQUEST_TIME\";s:10:\"1644452262\";}}","notice","2022-02-10 00:17:42","2022-02-10 00:17:42","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","5.2.69.50");
INSERT INTO ml_itsec_logs VALUES("34125","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"38248\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:9:\"5.2.69.50\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"228\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644452265.3325\";s:12:\"REQUEST_TIME\";s:10:\"1644452265\";}}","notice","2022-02-10 00:17:45","2022-02-10 00:17:45","7058896","7123888","https://www.messagetech.com/xmlrpc.php","1","0","5.2.69.50");
INSERT INTO ml_itsec_logs VALUES("34126","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41240\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:9:\"5.2.69.50\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644452268.2587\";s:12:\"REQUEST_TIME\";s:10:\"1644452268\";}}","notice","2022-02-10 00:17:48","2022-02-10 00:17:48","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","5.2.69.50");
INSERT INTO ml_itsec_logs VALUES("34127","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"42131\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"45.153.160.130\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644454227.8248\";s:12:\"REQUEST_TIME\";s:10:\"1644454227\";}}","notice","2022-02-10 00:50:27","2022-02-10 00:50:27","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","45.153.160.130");
INSERT INTO ml_itsec_logs VALUES("34128","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50447\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"31.206.10.80\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465207.1758\";s:12:\"REQUEST_TIME\";s:10:\"1644465207\";}}","notice","2022-02-10 03:53:27","2022-02-10 03:53:27","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","31.206.10.80");
INSERT INTO ml_itsec_logs VALUES("34129","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"61329\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"92.126.204.155\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465211.8972\";s:12:\"REQUEST_TIME\";s:10:\"1644465211\";}}","notice","2022-02-10 03:53:31","2022-02-10 03:53:31","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","92.126.204.155");
INSERT INTO ml_itsec_logs VALUES("34130","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"29807\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"189.219.48.11\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465224.8278\";s:12:\"REQUEST_TIME\";s:10:\"1644465224\";}}","notice","2022-02-10 03:53:44","2022-02-10 03:53:44","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","189.219.48.11");
INSERT INTO ml_itsec_logs VALUES("34131","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"45402\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"178.235.191.141\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465227.0172\";s:12:\"REQUEST_TIME\";s:10:\"1644465227\";}}","notice","2022-02-10 03:53:47","2022-02-10 03:53:47","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","178.235.191.141");
INSERT INTO ml_itsec_logs VALUES("34132","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"2421\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"189.203.100.200\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465231.6054\";s:12:\"REQUEST_TIME\";s:10:\"1644465231\";}}","notice","2022-02-10 03:53:51","2022-02-10 03:53:51","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","189.203.100.200");
INSERT INTO ml_itsec_logs VALUES("34133","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51653\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"124.122.4.67\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465246.8963\";s:12:\"REQUEST_TIME\";s:10:\"1644465246\";}}","notice","2022-02-10 03:54:06","2022-02-10 03:54:06","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","124.122.4.67");
INSERT INTO ml_itsec_logs VALUES("34134","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"31098\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"27.55.73.170\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465254.1977\";s:12:\"REQUEST_TIME\";s:10:\"1644465254\";}}","notice","2022-02-10 03:54:14","2022-02-10 03:54:14","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","27.55.73.170");
INSERT INTO ml_itsec_logs VALUES("34135","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58936\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"217.165.153.27\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"194\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465257.3984\";s:12:\"REQUEST_TIME\";s:10:\"1644465257\";}}","notice","2022-02-10 03:54:17","2022-02-10 03:54:17","7061816","7126808","https://messagetech.com/xmlrpc.php","1","0","217.165.153.27");
INSERT INTO ml_itsec_logs VALUES("34136","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"64386\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"190.15.201.70\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"194\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465263.2239\";s:12:\"REQUEST_TIME\";s:10:\"1644465263\";}}","notice","2022-02-10 03:54:23","2022-02-10 03:54:23","7061816","7126808","https://messagetech.com/xmlrpc.php","1","0","190.15.201.70");
INSERT INTO ml_itsec_logs VALUES("34137","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"5721\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"193.226.212.84\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"194\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644465273.9386\";s:12:\"REQUEST_TIME\";s:10:\"1644465273\";}}","notice","2022-02-10 03:54:33","2022-02-10 03:54:33","7061816","7126808","https://messagetech.com/xmlrpc.php","1","0","193.226.212.84");
INSERT INTO ml_itsec_logs VALUES("34138","0","lockout","user-lockout::1","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:1;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-09 22:54:33\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-10 03:54:33\";s:14:\"lockout_expire\";s:19:\"2022-02-09 23:09:33\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-10 04:09:33\";s:12:\"lockout_user\";i:1;}","action","2022-02-10 03:54:34","2022-02-10 03:54:33","7105896","7133160","https://messagetech.com/xmlrpc.php","1","0","193.226.212.84");
INSERT INTO ml_itsec_logs VALUES("34139","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"62928\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"205.164.142.167\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"195\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:13:\"1644466173.09\";s:12:\"REQUEST_TIME\";s:10:\"1644466173\";}}","notice","2022-02-10 04:09:33","2022-02-10 04:09:33","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","205.164.142.167");
INSERT INTO ml_itsec_logs VALUES("34140","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"65299\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"103.213.128.223\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"195\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644466176.0861\";s:12:\"REQUEST_TIME\";s:10:\"1644466176\";}}","notice","2022-02-10 04:09:36","2022-02-10 04:09:36","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","103.213.128.223");
INSERT INTO ml_itsec_logs VALUES("34141","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57290\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"104.244.72.91\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"230\";s:15:\"HTTP_USER_AGENT\";s:116:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/E7FBAF\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644474360.4694\";s:12:\"REQUEST_TIME\";s:10:\"1644474360\";}}","notice","2022-02-10 06:26:00","2022-02-10 06:26:00","7059544","7109128","https://www.messagetech.com/xmlrpc.php","1","0","104.244.72.91");
INSERT INTO ml_itsec_logs VALUES("34142","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57292\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"104.244.72.91\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:116:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/E7FBAF\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644474362.2782\";s:12:\"REQUEST_TIME\";s:10:\"1644474362\";}}","notice","2022-02-10 06:26:02","2022-02-10 06:26:02","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","104.244.72.91");
INSERT INTO ml_itsec_logs VALUES("34143","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57294\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"104.244.72.91\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:116:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/E7FBAF\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644474363.9926\";s:12:\"REQUEST_TIME\";s:10:\"1644474363\";}}","notice","2022-02-10 06:26:04","2022-02-10 06:26:04","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","104.244.72.91");
INSERT INTO ml_itsec_logs VALUES("34144","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57296\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"104.244.72.91\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:116:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/E7FBAF\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644474365.8249\";s:12:\"REQUEST_TIME\";s:10:\"1644474365\";}}","notice","2022-02-10 06:26:06","2022-02-10 06:26:05","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","104.244.72.91");
INSERT INTO ml_itsec_logs VALUES("34145","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60026\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"192.42.116.14\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:116:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/E7FBAF\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644474368.0385\";s:12:\"REQUEST_TIME\";s:10:\"1644474368\";}}","notice","2022-02-10 06:26:08","2022-02-10 06:26:08","7045152","7094736","https://www.messagetech.com/xmlrpc.php","1","0","192.42.116.14");
INSERT INTO ml_itsec_logs VALUES("34146","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"35204\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"192.42.116.14\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:116:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/E7FBAF\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644474369.9714\";s:12:\"REQUEST_TIME\";s:10:\"1644474369\";}}","notice","2022-02-10 06:26:10","2022-02-10 06:26:09","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","192.42.116.14");
INSERT INTO ml_itsec_logs VALUES("34147","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41019\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"81.214.165.44\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"213\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475394.3493\";s:12:\"REQUEST_TIME\";s:10:\"1644475394\";}}","notice","2022-02-10 06:43:15","2022-02-10 06:43:14","7051320","7104128","https://messagetech.com/xmlrpc.php","1","0","81.214.165.44");
INSERT INTO ml_itsec_logs VALUES("34148","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"5283\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"103.85.193.8\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644475399.167\";s:12:\"REQUEST_TIME\";s:10:\"1644475399\";}}","notice","2022-02-10 06:43:19","2022-02-10 06:43:19","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","103.85.193.8");
INSERT INTO ml_itsec_logs VALUES("34149","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"30298\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"176.58.139.219\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475401.7564\";s:12:\"REQUEST_TIME\";s:10:\"1644475401\";}}","notice","2022-02-10 06:43:21","2022-02-10 06:43:21","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","176.58.139.219");
INSERT INTO ml_itsec_logs VALUES("34150","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"65036\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"42.115.143.16\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475405.5802\";s:12:\"REQUEST_TIME\";s:10:\"1644475405\";}}","notice","2022-02-10 06:43:25","2022-02-10 06:43:25","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","42.115.143.16");
INSERT INTO ml_itsec_logs VALUES("34151","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"21697\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"151.246.218.204\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475408.6381\";s:12:\"REQUEST_TIME\";s:10:\"1644475408\";}}","notice","2022-02-10 06:43:28","2022-02-10 06:43:28","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","151.246.218.204");
INSERT INTO ml_itsec_logs VALUES("34152","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55125\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"212.47.136.144\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475412.0286\";s:12:\"REQUEST_TIME\";s:10:\"1644475412\";}}","notice","2022-02-10 06:43:32","2022-02-10 06:43:32","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","212.47.136.144");
INSERT INTO ml_itsec_logs VALUES("34153","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56216\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"156.174.19.199\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475430.7332\";s:12:\"REQUEST_TIME\";s:10:\"1644475430\";}}","notice","2022-02-10 06:43:50","2022-02-10 06:43:50","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","156.174.19.199");
INSERT INTO ml_itsec_logs VALUES("34154","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51721\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"49.237.17.93\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475439.5714\";s:12:\"REQUEST_TIME\";s:10:\"1644475439\";}}","notice","2022-02-10 06:43:59","2022-02-10 06:43:59","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","49.237.17.93");
INSERT INTO ml_itsec_logs VALUES("34155","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"11797\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"31.166.145.176\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644475445.687\";s:12:\"REQUEST_TIME\";s:10:\"1644475445\";}}","notice","2022-02-10 06:44:05","2022-02-10 06:44:05","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","31.166.145.176");
INSERT INTO ml_itsec_logs VALUES("34156","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52748\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"31.223.133.133\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644475448.7722\";s:12:\"REQUEST_TIME\";s:10:\"1644475448\";}}","notice","2022-02-10 06:44:09","2022-02-10 06:44:08","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","31.223.133.133");
INSERT INTO ml_itsec_logs VALUES("34157","0","lockout","user-lockout::2","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:2;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-10 01:44:08\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-10 06:44:08\";s:14:\"lockout_expire\";s:19:\"2022-02-10 01:59:08\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-10 06:59:08\";s:12:\"lockout_user\";i:2;}","action","2022-02-10 06:44:09","2022-02-10 06:44:08","7095352","7122256","https://messagetech.com/xmlrpc.php","1","0","31.223.133.133");
INSERT INTO ml_itsec_logs VALUES("34158","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"61369\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"81.16.33.42\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:127:\"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36 OPR/75.0.3969.149\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644478056.2056\";s:12:\"REQUEST_TIME\";s:10:\"1644478056\";}}","notice","2022-02-10 07:27:36","2022-02-10 07:27:36","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","81.16.33.42");
INSERT INTO ml_itsec_logs VALUES("34159","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"17604\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.36\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644487366.0472\";s:12:\"REQUEST_TIME\";s:10:\"1644487366\";}}","notice","2022-02-10 10:02:46","2022-02-10 10:02:46","7062768","7115576","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.36");
INSERT INTO ml_itsec_logs VALUES("34160","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"3944\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.36\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644487368.4851\";s:12:\"REQUEST_TIME\";s:10:\"1644487368\";}}","notice","2022-02-10 10:02:48","2022-02-10 10:02:48","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.36");
INSERT INTO ml_itsec_logs VALUES("34161","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"12660\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.36\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644487370.7231\";s:12:\"REQUEST_TIME\";s:10:\"1644487370\";}}","notice","2022-02-10 10:02:51","2022-02-10 10:02:50","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.36");
INSERT INTO ml_itsec_logs VALUES("34162","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49632\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"192.42.116.17\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644487372.9886\";s:12:\"REQUEST_TIME\";s:10:\"1644487372\";}}","notice","2022-02-10 10:02:53","2022-02-10 10:02:53","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","192.42.116.17");
INSERT INTO ml_itsec_logs VALUES("34163","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52772\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"192.42.116.17\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"233\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644487375.3689\";s:12:\"REQUEST_TIME\";s:10:\"1644487375\";}}","notice","2022-02-10 10:02:55","2022-02-10 10:02:55","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","192.42.116.17");
INSERT INTO ml_itsec_logs VALUES("34164","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49272\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"91.219.236.197\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644487377.8151\";s:12:\"REQUEST_TIME\";s:10:\"1644487377\";}}","notice","2022-02-10 10:02:57","2022-02-10 10:02:57","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","91.219.236.197");
INSERT INTO ml_itsec_logs VALUES("34165","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"8610\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.248\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/11.1 Safari/605.1.15\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644495635.3977\";s:12:\"REQUEST_TIME\";s:10:\"1644495635\";}}","notice","2022-02-10 12:20:35","2022-02-10 12:20:35","7058976","7123968","https://blog.messagetech.com/xmlrpc.php","1","0","185.220.102.248");
INSERT INTO ml_itsec_logs VALUES("34166","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52921\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.81.218\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"489\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644522025.5154\";s:12:\"REQUEST_TIME\";s:10:\"1644522025\";}}","notice","2022-02-10 19:40:26","2022-02-10 19:40:25","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","137.184.81.218");
INSERT INTO ml_itsec_logs VALUES("34167","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53728\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.81.218\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"489\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644522026.765\";s:12:\"REQUEST_TIME\";s:10:\"1644522026\";}}","notice","2022-02-10 19:40:26","2022-02-10 19:40:26","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","137.184.81.218");
INSERT INTO ml_itsec_logs VALUES("34168","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54174\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.81.218\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644522027.4192\";s:12:\"REQUEST_TIME\";s:10:\"1644522027\";}}","notice","2022-02-10 19:40:27","2022-02-10 19:40:27","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","137.184.81.218");
INSERT INTO ml_itsec_logs VALUES("34169","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54457\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.81.218\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644522027.9213\";s:12:\"REQUEST_TIME\";s:10:\"1644522027\";}}","notice","2022-02-10 19:40:27","2022-02-10 19:40:27","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","137.184.81.218");
INSERT INTO ml_itsec_logs VALUES("34170","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54790\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.81.218\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644522028.4218\";s:12:\"REQUEST_TIME\";s:10:\"1644522028\";}}","notice","2022-02-10 19:40:28","2022-02-10 19:40:28","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","137.184.81.218");
INSERT INTO ml_itsec_logs VALUES("34171","0","lockout","host-lockout::137.184.81.218","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:14:\"137.184.81.218\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-10 14:40:28\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-10 19:40:28\";s:14:\"lockout_expire\";s:19:\"2022-02-10 14:55:28\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-10 19:55:28\";s:12:\"lockout_host\";s:14:\"137.184.81.218\";}","action","2022-02-10 19:40:29","2022-02-10 19:40:28","7106568","7134176","https://www.messagetech.com//xmlrpc.php","1","0","137.184.81.218");
INSERT INTO ml_itsec_logs VALUES("34172","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1882\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.87\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"228\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644531269.4799\";s:12:\"REQUEST_TIME\";s:10:\"1644531269\";}}","notice","2022-02-10 22:14:30","2022-02-10 22:14:29","7073296","7138288","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.87");
INSERT INTO ml_itsec_logs VALUES("34173","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"8656\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.87\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644531273.1819\";s:12:\"REQUEST_TIME\";s:10:\"1644531273\";}}","notice","2022-02-10 22:14:33","2022-02-10 22:14:33","7058896","7123888","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.87");
INSERT INTO ml_itsec_logs VALUES("34174","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"8780\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.87\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644531276.2085\";s:12:\"REQUEST_TIME\";s:10:\"1644531276\";}}","notice","2022-02-10 22:14:36","2022-02-10 22:14:36","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.87");
INSERT INTO ml_itsec_logs VALUES("34175","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33990\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"45.154.255.147\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"225\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644531279.4457\";s:12:\"REQUEST_TIME\";s:10:\"1644531279\";}}","notice","2022-02-10 22:14:39","2022-02-10 22:14:39","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","45.154.255.147");
INSERT INTO ml_itsec_logs VALUES("34176","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52192\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"45.154.255.147\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"228\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644531282.9525\";s:12:\"REQUEST_TIME\";s:10:\"1644531282\";}}","notice","2022-02-10 22:14:43","2022-02-10 22:14:42","7058896","7123888","https://www.messagetech.com/xmlrpc.php","1","0","45.154.255.147");
INSERT INTO ml_itsec_logs VALUES("34177","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49996\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"201.103.209.35\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"210\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534250.2363\";s:12:\"REQUEST_TIME\";s:10:\"1644534250\";}}","notice","2022-02-10 23:04:10","2022-02-10 23:04:10","7051320","7104128","https://messagetech.com/xmlrpc.php","1","0","201.103.209.35");
INSERT INTO ml_itsec_logs VALUES("34178","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1441\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"181.62.53.45\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534254.5055\";s:12:\"REQUEST_TIME\";s:10:\"1644534254\";}}","notice","2022-02-10 23:04:14","2022-02-10 23:04:14","7065680","7118488","https://messagetech.com/xmlrpc.php","1","0","181.62.53.45");
INSERT INTO ml_itsec_logs VALUES("34179","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60502\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"130.255.250.118\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534267.8196\";s:12:\"REQUEST_TIME\";s:10:\"1644534267\";}}","notice","2022-02-10 23:04:27","2022-02-10 23:04:27","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","130.255.250.118");
INSERT INTO ml_itsec_logs VALUES("34180","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"17702\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"201.71.164.188\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534274.4458\";s:12:\"REQUEST_TIME\";s:10:\"1644534274\";}}","notice","2022-02-10 23:04:34","2022-02-10 23:04:34","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","201.71.164.188");
INSERT INTO ml_itsec_logs VALUES("34181","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58036\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"196.117.120.38\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534276.7289\";s:12:\"REQUEST_TIME\";s:10:\"1644534276\";}}","notice","2022-02-10 23:04:36","2022-02-10 23:04:36","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","196.117.120.38");
INSERT INTO ml_itsec_logs VALUES("34182","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"5907\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"186.210.245.217\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534289.4688\";s:12:\"REQUEST_TIME\";s:10:\"1644534289\";}}","notice","2022-02-10 23:04:49","2022-02-10 23:04:49","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","186.210.245.217");
INSERT INTO ml_itsec_logs VALUES("34183","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49220\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"88.212.41.121\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"205\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534292.5577\";s:12:\"REQUEST_TIME\";s:10:\"1644534292\";}}","notice","2022-02-10 23:04:52","2022-02-10 23:04:52","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","88.212.41.121");
INSERT INTO ml_itsec_logs VALUES("34184","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56913\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"178.137.242.248\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"205\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534294.6863\";s:12:\"REQUEST_TIME\";s:10:\"1644534294\";}}","notice","2022-02-10 23:04:55","2022-02-10 23:04:54","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","178.137.242.248");
INSERT INTO ml_itsec_logs VALUES("34185","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55652\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"190.120.255.218\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534298.1556\";s:12:\"REQUEST_TIME\";s:10:\"1644534298\";}}","notice","2022-02-10 23:04:58","2022-02-10 23:04:58","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","190.120.255.218");
INSERT INTO ml_itsec_logs VALUES("34186","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53627\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"103.108.128.170\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644534301.0545\";s:12:\"REQUEST_TIME\";s:10:\"1644534301\";}}","notice","2022-02-10 23:05:01","2022-02-10 23:05:01","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","103.108.128.170");
INSERT INTO ml_itsec_logs VALUES("34187","0","lockout","user-lockout::2","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:2;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-10 18:05:01\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-10 23:05:01\";s:14:\"lockout_expire\";s:19:\"2022-02-10 18:20:01\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-10 23:20:01\";s:12:\"lockout_user\";i:2;}","action","2022-02-10 23:05:01","2022-02-10 23:05:01","7095352","7122256","https://messagetech.com/xmlrpc.php","1","0","103.108.128.170");
INSERT INTO ml_itsec_logs VALUES("34188","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"39085\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"104.244.72.36\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36 OPR/73.0.3856.344\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"234\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644553625.3501\";s:12:\"REQUEST_TIME\";s:10:\"1644553625\";}}","notice","2022-02-11 04:27:05","2022-02-11 04:27:05","7045248","7094832","https://messagetech.com/xmlrpc.php","1","0","104.244.72.36");
INSERT INTO ml_itsec_logs VALUES("34189","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"40745\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"107.189.29.41\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:65:\"Mozilla/5.0 (Windows NT 6.3; rv:84.0) Gecko/20100101 Firefox/84.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644569957.7156\";s:12:\"REQUEST_TIME\";s:10:\"1644569957\";}}","notice","2022-02-11 08:59:17","2022-02-11 08:59:17","7048280","7101088","https://messagetech.com/xmlrpc.php","1","0","107.189.29.41");
INSERT INTO ml_itsec_logs VALUES("34190","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"45191\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"45.61.186.113\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:126:\"Mozilla/5.0 (iPad; CPU OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644574288.3404\";s:12:\"REQUEST_TIME\";s:10:\"1644574288\";}}","notice","2022-02-11 10:11:28","2022-02-11 10:11:28","7058976","7123968","https://faq.messagetech.com/xmlrpc.php","1","0","45.61.186.113");
INSERT INTO ml_itsec_logs VALUES("34191","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54494\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.94.250\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"489\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644577607.8325\";s:12:\"REQUEST_TIME\";s:10:\"1644577607\";}}","notice","2022-02-11 11:06:47","2022-02-11 11:06:47","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","137.184.94.250");
INSERT INTO ml_itsec_logs VALUES("34192","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54774\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.94.250\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"489\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644577608.3632\";s:12:\"REQUEST_TIME\";s:10:\"1644577608\";}}","notice","2022-02-11 11:06:49","2022-02-11 11:06:48","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","137.184.94.250");
INSERT INTO ml_itsec_logs VALUES("34193","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55771\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.94.250\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644577610.1798\";s:12:\"REQUEST_TIME\";s:10:\"1644577610\";}}","notice","2022-02-11 11:06:50","2022-02-11 11:06:50","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","137.184.94.250");
INSERT INTO ml_itsec_logs VALUES("34194","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56138\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.94.250\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644577610.7933\";s:12:\"REQUEST_TIME\";s:10:\"1644577610\";}}","notice","2022-02-11 11:06:50","2022-02-11 11:06:50","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","137.184.94.250");
INSERT INTO ml_itsec_logs VALUES("34195","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56491\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"137.184.94.250\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644577611.4561\";s:12:\"REQUEST_TIME\";s:10:\"1644577611\";}}","notice","2022-02-11 11:06:51","2022-02-11 11:06:51","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","137.184.94.250");
INSERT INTO ml_itsec_logs VALUES("34196","0","lockout","host-lockout::137.184.94.250","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:14:\"137.184.94.250\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-11 06:06:51\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-11 11:06:51\";s:14:\"lockout_expire\";s:19:\"2022-02-11 06:21:51\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-11 11:21:51\";s:12:\"lockout_host\";s:14:\"137.184.94.250\";}","action","2022-02-11 11:06:51","2022-02-11 11:06:51","7106568","7134176","https://www.messagetech.com//xmlrpc.php","1","0","137.184.94.250");
INSERT INTO ml_itsec_logs VALUES("34197","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"27618\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.248\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:126:\"Mozilla/5.0 (iPad; CPU OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644608223.8459\";s:12:\"REQUEST_TIME\";s:10:\"1644608223\";}}","notice","2022-02-11 19:37:03","2022-02-11 19:37:03","7059024","7124000","https://client.messagetech.com/xmlrpc.php","1","0","185.220.100.248");
INSERT INTO ml_itsec_logs VALUES("34198","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49582\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"176.10.104.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644610518.2018\";s:12:\"REQUEST_TIME\";s:10:\"1644610518\";}}","notice","2022-02-11 20:15:18","2022-02-11 20:15:18","7058800","7123792","https://www.messagetech.com/xmlrpc.php","1","0","176.10.104.240");
INSERT INTO ml_itsec_logs VALUES("34199","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"30184\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.243\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"228\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644610520.2088\";s:12:\"REQUEST_TIME\";s:10:\"1644610520\";}}","notice","2022-02-11 20:15:20","2022-02-11 20:15:20","7058800","7123792","https://www.messagetech.com/xmlrpc.php","1","0","185.220.102.243");
INSERT INTO ml_itsec_logs VALUES("34200","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"26314\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.243\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644610522.2017\";s:12:\"REQUEST_TIME\";s:10:\"1644610522\";}}","notice","2022-02-11 20:15:22","2022-02-11 20:15:22","7058864","7123856","https://www.messagetech.com/xmlrpc.php","1","0","185.220.102.243");
INSERT INTO ml_itsec_logs VALUES("34201","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33254\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.243\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644610524.3007\";s:12:\"REQUEST_TIME\";s:10:\"1644610524\";}}","notice","2022-02-11 20:15:24","2022-02-11 20:15:24","7058792","7123784","https://www.messagetech.com/xmlrpc.php","1","0","185.220.102.243");
INSERT INTO ml_itsec_logs VALUES("34202","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"29988\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.243\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"227\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644610526.511\";s:12:\"REQUEST_TIME\";s:10:\"1644610526\";}}","notice","2022-02-11 20:15:26","2022-02-11 20:15:26","7058792","7123784","https://www.messagetech.com/xmlrpc.php","1","0","185.220.102.243");
INSERT INTO ml_itsec_logs VALUES("34203","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41077\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.27\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644610528.8113\";s:12:\"REQUEST_TIME\";s:10:\"1644610528\";}}","notice","2022-02-11 20:15:28","2022-02-11 20:15:28","7058792","7123784","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.27");
INSERT INTO ml_itsec_logs VALUES("34204","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34653\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.27\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:16.0) Gecko/20100101 Firefox/16.0\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644610531.0435\";s:12:\"REQUEST_TIME\";s:10:\"1644610531\";}}","notice","2022-02-11 20:15:31","2022-02-11 20:15:31","7058800","7123792","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.27");
INSERT INTO ml_itsec_logs VALUES("34205","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"40035\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.35\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:131:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36 OPR/75.0.3969.149\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644615789.6895\";s:12:\"REQUEST_TIME\";s:10:\"1644615789\";}}","notice","2022-02-11 21:43:09","2022-02-11 21:43:09","7073328","7138320","https://messagetech.com/xmlrpc.php","1","0","109.70.100.35");
INSERT INTO ml_itsec_logs VALUES("34206","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"30024\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.66\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.13; rv:62.0) Gecko/20100101 Firefox/62.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644617224.5313\";s:12:\"REQUEST_TIME\";s:10:\"1644617224\";}}","notice","2022-02-11 22:07:04","2022-02-11 22:07:04","7058832","7123824","https://messagetech.com/xmlrpc.php","1","0","185.220.101.66");
INSERT INTO ml_itsec_logs VALUES("34207","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55821\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"54.183.191.108\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"484\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644619256.7624\";s:12:\"REQUEST_TIME\";s:10:\"1644619256\";}}","notice","2022-02-11 22:40:56","2022-02-11 22:40:56","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","54.183.191.108");
INSERT INTO ml_itsec_logs VALUES("34208","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49338\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"54.183.191.108\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"483\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644619257.2801\";s:12:\"REQUEST_TIME\";s:10:\"1644619257\";}}","notice","2022-02-11 22:40:57","2022-02-11 22:40:57","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","54.183.191.108");
INSERT INTO ml_itsec_logs VALUES("34209","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56821\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"54.183.191.108\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644619257.7769\";s:12:\"REQUEST_TIME\";s:10:\"1644619257\";}}","notice","2022-02-11 22:40:57","2022-02-11 22:40:57","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","54.183.191.108");
INSERT INTO ml_itsec_logs VALUES("34210","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51276\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"54.183.191.108\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644619258.2816\";s:12:\"REQUEST_TIME\";s:10:\"1644619258\";}}","notice","2022-02-11 22:40:58","2022-02-11 22:40:58","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","54.183.191.108");
INSERT INTO ml_itsec_logs VALUES("34211","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"65335\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"54.183.191.108\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"488\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644619258.7746\";s:12:\"REQUEST_TIME\";s:10:\"1644619258\";}}","notice","2022-02-11 22:40:59","2022-02-11 22:40:58","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","54.183.191.108");
INSERT INTO ml_itsec_logs VALUES("34212","0","lockout","host-lockout::54.183.191.108","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:14:\"54.183.191.108\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-11 17:40:58\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-11 22:40:58\";s:14:\"lockout_expire\";s:19:\"2022-02-11 17:55:58\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-11 22:55:58\";s:12:\"lockout_host\";s:14:\"54.183.191.108\";}","action","2022-02-11 22:40:59","2022-02-11 22:40:58","7106576","7134184","https://www.messagetech.com//xmlrpc.php","1","0","54.183.191.108");
INSERT INTO ml_itsec_logs VALUES("34213","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"36808\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"195.144.21.219\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632603.6992\";s:12:\"REQUEST_TIME\";s:10:\"1644632603\";}}","notice","2022-02-12 02:23:23","2022-02-12 02:23:23","7045216","7094800","https://www.messagetech.com/xmlrpc.php","1","0","195.144.21.219");
INSERT INTO ml_itsec_logs VALUES("34214","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"38076\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"195.144.21.219\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632605.8136\";s:12:\"REQUEST_TIME\";s:10:\"1644632605\";}}","notice","2022-02-12 02:23:25","2022-02-12 02:23:25","7045152","7094736","https://www.messagetech.com/xmlrpc.php","1","0","195.144.21.219");
INSERT INTO ml_itsec_logs VALUES("34215","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"35737\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"178.20.55.18\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"235\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632607.5058\";s:12:\"REQUEST_TIME\";s:10:\"1644632607\";}}","notice","2022-02-12 02:23:28","2022-02-12 02:23:27","7045216","7094800","https://www.messagetech.com/xmlrpc.php","1","0","178.20.55.18");
INSERT INTO ml_itsec_logs VALUES("34216","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"27322\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.35\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632609.7965\";s:12:\"REQUEST_TIME\";s:10:\"1644632609\";}}","notice","2022-02-12 02:23:29","2022-02-12 02:23:29","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.35");
INSERT INTO ml_itsec_logs VALUES("34217","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"26908\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.35\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"230\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632611.5426\";s:12:\"REQUEST_TIME\";s:10:\"1644632611\";}}","notice","2022-02-12 02:23:31","2022-02-12 02:23:31","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.35");
INSERT INTO ml_itsec_logs VALUES("34218","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1382\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.11\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632613.4606\";s:12:\"REQUEST_TIME\";s:10:\"1644632613\";}}","notice","2022-02-12 02:23:33","2022-02-12 02:23:33","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.11");
INSERT INTO ml_itsec_logs VALUES("34219","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"9666\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.11\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.157 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644632615.3381\";s:12:\"REQUEST_TIME\";s:10:\"1644632615\";}}","notice","2022-02-12 02:23:35","2022-02-12 02:23:35","7045216","7094800","https://www.messagetech.com/xmlrpc.php","1","0","185.220.101.11");
INSERT INTO ml_itsec_logs VALUES("34220","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"25800\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.241\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"234\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644645519.924\";s:12:\"REQUEST_TIME\";s:10:\"1644645519\";}}","notice","2022-02-12 05:58:39","2022-02-12 05:58:39","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","185.220.100.241");
INSERT INTO ml_itsec_logs VALUES("34221","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"31696\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.241\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"233\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644645522.1491\";s:12:\"REQUEST_TIME\";s:10:\"1644645522\";}}","notice","2022-02-12 05:58:42","2022-02-12 05:58:42","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","185.220.100.241");
INSERT INTO ml_itsec_logs VALUES("34222","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"27568\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.241\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"237\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644645524.6394\";s:12:\"REQUEST_TIME\";s:10:\"1644645524\";}}","notice","2022-02-12 05:58:44","2022-02-12 05:58:44","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","185.220.100.241");
INSERT INTO ml_itsec_logs VALUES("34223","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33331\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.23\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644645528.4592\";s:12:\"REQUEST_TIME\";s:10:\"1644645528\";}}","notice","2022-02-12 05:58:48","2022-02-12 05:58:48","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.23");
INSERT INTO ml_itsec_logs VALUES("34224","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"38411\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.84\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"232\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644645530.8349\";s:12:\"REQUEST_TIME\";s:10:\"1644645530\";}}","notice","2022-02-12 05:58:51","2022-02-12 05:58:50","7048368","7101176","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.84");
INSERT INTO ml_itsec_logs VALUES("34225","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34489\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.84\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644645533.7864\";s:12:\"REQUEST_TIME\";s:10:\"1644645533\";}}","notice","2022-02-12 05:58:53","2022-02-12 05:58:53","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.84");
INSERT INTO ml_itsec_logs VALUES("34226","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34411\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.84\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"234\";s:15:\"HTTP_USER_AGENT\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644645535.9484\";s:12:\"REQUEST_TIME\";s:10:\"1644645535\";}}","notice","2022-02-12 05:58:56","2022-02-12 05:58:55","7048376","7101184","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.84");
INSERT INTO ml_itsec_logs VALUES("34227","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1755\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"185.100.85.25\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644660536.9986\";s:12:\"REQUEST_TIME\";s:10:\"1644660536\";}}","notice","2022-02-12 10:08:57","2022-02-12 10:08:57","7058976","7123968","https://blog.messagetech.com/xmlrpc.php","1","0","185.100.85.25");
INSERT INTO ml_itsec_logs VALUES("34228","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33964\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"42.113.166.177\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668372.2694\";s:12:\"REQUEST_TIME\";s:10:\"1644668372\";}}","notice","2022-02-12 12:19:32","2022-02-12 12:19:32","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","42.113.166.177");
INSERT INTO ml_itsec_logs VALUES("34229","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51648\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"113.168.89.19\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"195\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668386.5968\";s:12:\"REQUEST_TIME\";s:10:\"1644668386\";}}","notice","2022-02-12 12:19:46","2022-02-12 12:19:46","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","113.168.89.19");
INSERT INTO ml_itsec_logs VALUES("34230","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55317\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"111.94.178.189\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"195\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668390.3279\";s:12:\"REQUEST_TIME\";s:10:\"1644668390\";}}","notice","2022-02-12 12:19:51","2022-02-12 12:19:50","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","111.94.178.189");
INSERT INTO ml_itsec_logs VALUES("34231","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"64804\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"5.107.218.141\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"195\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668404.2013\";s:12:\"REQUEST_TIME\";s:10:\"1644668404\";}}","notice","2022-02-12 12:20:04","2022-02-12 12:20:04","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","5.107.218.141");
INSERT INTO ml_itsec_logs VALUES("34232","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58635\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"45.172.110.105\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"195\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668418.7537\";s:12:\"REQUEST_TIME\";s:10:\"1644668418\";}}","notice","2022-02-12 12:20:18","2022-02-12 12:20:18","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","45.172.110.105");
INSERT INTO ml_itsec_logs VALUES("34233","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50222\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"42.118.10.90\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"193\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668422.1032\";s:12:\"REQUEST_TIME\";s:10:\"1644668422\";}}","notice","2022-02-12 12:20:22","2022-02-12 12:20:22","7061808","7126800","https://messagetech.com/xmlrpc.php","1","0","42.118.10.90");
INSERT INTO ml_itsec_logs VALUES("34234","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55914\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"85.102.188.0\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"202\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668424.6961\";s:12:\"REQUEST_TIME\";s:10:\"1644668424\";}}","notice","2022-02-12 12:20:24","2022-02-12 12:20:24","7061864","7126856","https://messagetech.com/xmlrpc.php","1","0","85.102.188.0");
INSERT INTO ml_itsec_logs VALUES("34235","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"3821\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"119.76.1.122\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668435.7115\";s:12:\"REQUEST_TIME\";s:10:\"1644668435\";}}","notice","2022-02-12 12:20:35","2022-02-12 12:20:35","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","119.76.1.122");
INSERT INTO ml_itsec_logs VALUES("34236","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51088\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"8.21.11.142\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"202\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668440.0287\";s:12:\"REQUEST_TIME\";s:10:\"1644668440\";}}","notice","2022-02-12 12:20:40","2022-02-12 12:20:40","7061864","7126856","https://messagetech.com/xmlrpc.php","1","0","8.21.11.142");
INSERT INTO ml_itsec_logs VALUES("34237","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"18001\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"46.39.55.91\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"196\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644668446.5854\";s:12:\"REQUEST_TIME\";s:10:\"1644668446\";}}","notice","2022-02-12 12:20:46","2022-02-12 12:20:46","7061824","7126816","https://messagetech.com/xmlrpc.php","1","0","46.39.55.91");
INSERT INTO ml_itsec_logs VALUES("34238","0","lockout","user-lockout::1","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:1;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-12 07:20:46\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-12 12:20:46\";s:14:\"lockout_expire\";s:19:\"2022-02-12 07:35:46\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-12 12:35:46\";s:12:\"lockout_user\";i:1;}","action","2022-02-12 12:20:46","2022-02-12 12:20:46","7105904","7133168","https://messagetech.com/xmlrpc.php","1","0","46.39.55.91");
INSERT INTO ml_itsec_logs VALUES("34239","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51070\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"196.189.233.4\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"209\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686775.9768\";s:12:\"REQUEST_TIME\";s:10:\"1644686775\";}}","notice","2022-02-12 17:26:16","2022-02-12 17:26:15","7051288","7104096","https://messagetech.com/xmlrpc.php","1","0","196.189.233.4");
INSERT INTO ml_itsec_logs VALUES("34240","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"64306\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"46.99.82.116\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686779.5921\";s:12:\"REQUEST_TIME\";s:10:\"1644686779\";}}","notice","2022-02-12 17:26:19","2022-02-12 17:26:19","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","46.99.82.116");
INSERT INTO ml_itsec_logs VALUES("34241","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"14558\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"190.56.117.208\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686792.5576\";s:12:\"REQUEST_TIME\";s:10:\"1644686792\";}}","notice","2022-02-12 17:26:32","2022-02-12 17:26:32","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","190.56.117.208");
INSERT INTO ml_itsec_logs VALUES("34242","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50246\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"85.196.211.107\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686794.9411\";s:12:\"REQUEST_TIME\";s:10:\"1644686794\";}}","notice","2022-02-12 17:26:35","2022-02-12 17:26:34","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","85.196.211.107");
INSERT INTO ml_itsec_logs VALUES("34243","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51561\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"41.108.93.163\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686798.0121\";s:12:\"REQUEST_TIME\";s:10:\"1644686798\";}}","notice","2022-02-12 17:26:38","2022-02-12 17:26:38","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","41.108.93.163");
INSERT INTO ml_itsec_logs VALUES("34244","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51003\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"201.226.165.185\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686801.1736\";s:12:\"REQUEST_TIME\";s:10:\"1644686801\";}}","notice","2022-02-12 17:26:41","2022-02-12 17:26:41","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","201.226.165.185");
INSERT INTO ml_itsec_logs VALUES("34245","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"50231\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"204.199.90.206\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686804.0726\";s:12:\"REQUEST_TIME\";s:10:\"1644686804\";}}","notice","2022-02-12 17:26:44","2022-02-12 17:26:44","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","204.199.90.206");
INSERT INTO ml_itsec_logs VALUES("34246","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52624\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"41.109.141.142\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"204\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686807.4543\";s:12:\"REQUEST_TIME\";s:10:\"1644686807\";}}","notice","2022-02-12 17:26:47","2022-02-12 17:26:47","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","41.109.141.142");
INSERT INTO ml_itsec_logs VALUES("34247","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55030\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"92.86.177.92\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"204\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686809.7359\";s:12:\"REQUEST_TIME\";s:10:\"1644686809\";}}","notice","2022-02-12 17:26:50","2022-02-12 17:26:49","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","92.86.177.92");
INSERT INTO ml_itsec_logs VALUES("34248","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"12400\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"188.70.52.144\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"204\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644686814.3779\";s:12:\"REQUEST_TIME\";s:10:\"1644686814\";}}","notice","2022-02-12 17:26:54","2022-02-12 17:26:54","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","188.70.52.144");
INSERT INTO ml_itsec_logs VALUES("34249","0","lockout","user-lockout::2","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:2;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-12 12:26:54\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-12 17:26:54\";s:14:\"lockout_expire\";s:19:\"2022-02-12 12:41:54\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-12 17:41:54\";s:12:\"lockout_user\";i:2;}","action","2022-02-12 17:26:54","2022-02-12 17:26:54","7095352","7122256","https://messagetech.com/xmlrpc.php","1","0","188.70.52.144");
INSERT INTO ml_itsec_logs VALUES("34250","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"38219\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.32\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:127:\"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36 OPR/73.0.3856.344\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644691718.5622\";s:12:\"REQUEST_TIME\";s:10:\"1644691718\";}}","notice","2022-02-12 18:48:38","2022-02-12 18:48:38","7045184","7094768","https://messagetech.com/xmlrpc.php","1","0","109.70.100.32");
INSERT INTO ml_itsec_logs VALUES("34251","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"13012\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.21\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:65:\"Mozilla/5.0 (Windows NT 6.1; rv:85.0) Gecko/20100101 Firefox/85.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644707299.7645\";s:12:\"REQUEST_TIME\";s:10:\"1644707299\";}}","notice","2022-02-12 23:08:20","2022-02-12 23:08:19","7048216","7101024","https://messagetech.com/xmlrpc.php","1","0","185.220.101.21");
INSERT INTO ml_itsec_logs VALUES("34252","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"45558\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"176.10.104.240\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:129:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644735910.9608\";s:12:\"REQUEST_TIME\";s:10:\"1644735910\";}}","notice","2022-02-13 07:05:11","2022-02-13 07:05:10","7058976","7123968","https://faq.messagetech.com/xmlrpc.php","1","0","176.10.104.240");
INSERT INTO ml_itsec_logs VALUES("34253","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"6554\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.246\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:126:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36 OPR/75.0.3969.141\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644747756.666\";s:12:\"REQUEST_TIME\";s:10:\"1644747756\";}}","notice","2022-02-13 10:22:36","2022-02-13 10:22:36","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","185.220.102.246");
INSERT INTO ml_itsec_logs VALUES("34254","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"33475\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"185.14.97.145\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644766077.9497\";s:12:\"REQUEST_TIME\";s:10:\"1644766077\";}}","notice","2022-02-13 15:27:58","2022-02-13 15:27:57","7059024","7124000","https://client.messagetech.com/xmlrpc.php","1","0","185.14.97.145");
INSERT INTO ml_itsec_logs VALUES("34255","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"5538\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.59\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:77:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644774152.6892\";s:12:\"REQUEST_TIME\";s:10:\"1644774152\";}}","notice","2022-02-13 17:42:32","2022-02-13 17:42:32","7058832","7123824","https://messagetech.com/xmlrpc.php","1","0","185.220.101.59");
INSERT INTO ml_itsec_logs VALUES("34256","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"43781\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"109.70.100.27\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644789585.8918\";s:12:\"REQUEST_TIME\";s:10:\"1644789585\";}}","notice","2022-02-13 21:59:45","2022-02-13 21:59:45","7058888","7123880","https://www.messagetech.com/xmlrpc.php","1","0","109.70.100.27");
INSERT INTO ml_itsec_logs VALUES("34257","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"32522\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"176.63.3.129\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"201\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802293.0134\";s:12:\"REQUEST_TIME\";s:10:\"1644802293\";}}","notice","2022-02-14 01:31:33","2022-02-14 01:31:33","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","176.63.3.129");
INSERT INTO ml_itsec_logs VALUES("34258","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60728\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"217.147.1.82\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"198\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802299.3021\";s:12:\"REQUEST_TIME\";s:10:\"1644802299\";}}","notice","2022-02-14 01:31:39","2022-02-14 01:31:39","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","217.147.1.82");
INSERT INTO ml_itsec_logs VALUES("34259","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54708\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"201.167.133.18\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"198\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802302.3141\";s:12:\"REQUEST_TIME\";s:10:\"1644802302\";}}","notice","2022-02-14 01:31:42","2022-02-14 01:31:42","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","201.167.133.18");
INSERT INTO ml_itsec_logs VALUES("34260","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"59020\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"182.173.75.198\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"198\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802305.2731\";s:12:\"REQUEST_TIME\";s:10:\"1644802305\";}}","notice","2022-02-14 01:31:45","2022-02-14 01:31:45","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","182.173.75.198");
INSERT INTO ml_itsec_logs VALUES("34261","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54695\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"186.139.237.61\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802308.9827\";s:12:\"REQUEST_TIME\";s:10:\"1644802308\";}}","notice","2022-02-14 01:31:49","2022-02-14 01:31:49","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","186.139.237.61");
INSERT INTO ml_itsec_logs VALUES("34262","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"7647\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"187.188.227.188\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802311.9306\";s:12:\"REQUEST_TIME\";s:10:\"1644802311\";}}","notice","2022-02-14 01:31:51","2022-02-14 01:31:51","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","187.188.227.188");
INSERT INTO ml_itsec_logs VALUES("34263","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58987\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"78.84.79.167\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644802314.745\";s:12:\"REQUEST_TIME\";s:10:\"1644802314\";}}","notice","2022-02-14 01:31:54","2022-02-14 01:31:54","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","78.84.79.167");
INSERT INTO ml_itsec_logs VALUES("34264","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"63215\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"84.196.11.25\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644802324.629\";s:12:\"REQUEST_TIME\";s:10:\"1644802324\";}}","notice","2022-02-14 01:32:04","2022-02-14 01:32:04","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","84.196.11.25");
INSERT INTO ml_itsec_logs VALUES("34265","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53841\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"5.12.133.123\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644802332.8851\";s:12:\"REQUEST_TIME\";s:10:\"1644802332\";}}","notice","2022-02-14 01:32:13","2022-02-14 01:32:12","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","5.12.133.123");
INSERT INTO ml_itsec_logs VALUES("34266","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54296\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"118.137.138.136\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"201\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644802336.984\";s:12:\"REQUEST_TIME\";s:10:\"1644802336\";}}","notice","2022-02-14 01:32:17","2022-02-14 01:32:16","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","118.137.138.136");
INSERT INTO ml_itsec_logs VALUES("34267","0","lockout","user-lockout::3","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:3;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-13 20:32:16\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-14 01:32:16\";s:14:\"lockout_expire\";s:19:\"2022-02-13 20:47:16\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-14 01:47:16\";s:12:\"lockout_user\";i:3;}","action","2022-02-14 01:32:17","2022-02-14 01:32:16","7092192","7119456","https://messagetech.com/xmlrpc.php","1","0","118.137.138.136");
INSERT INTO ml_itsec_logs VALUES("34268","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52672\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"91.219.236.228\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644812586.6782\";s:12:\"REQUEST_TIME\";s:10:\"1644812586\";}}","notice","2022-02-14 04:23:06","2022-02-14 04:23:06","7045144","7094728","https://www.messagetech.com/xmlrpc.php","1","0","91.219.236.228");
INSERT INTO ml_itsec_logs VALUES("34269","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"44733\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"46.29.248.238\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644812821.9969\";s:12:\"REQUEST_TIME\";s:10:\"1644812821\";}}","notice","2022-02-14 04:27:02","2022-02-14 04:27:02","7058976","7123968","https://blog.messagetech.com/xmlrpc.php","1","0","46.29.248.238");
INSERT INTO ml_itsec_logs VALUES("34270","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"57986\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"199.249.230.80\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:78:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:89.0) Gecko/20100101 Firefox/89.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644817363.3913\";s:12:\"REQUEST_TIME\";s:10:\"1644817363\";}}","notice","2022-02-14 05:42:43","2022-02-14 05:42:43","7045088","7094672","https://messagetech.com/xmlrpc.php","1","0","199.249.230.80");
INSERT INTO ml_itsec_logs VALUES("34271","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"41974\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"107.189.30.58\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"CONTENT_TYPE\";s:22:\"text/xml;charset=utf-8\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644826216.4368\";s:12:\"REQUEST_TIME\";s:10:\"1644826216\";}}","notice","2022-02-14 08:10:16","2022-02-14 08:10:16","7048304","7101112","https://www.messagetech.com/xmlrpc.php","1","0","107.189.30.58");
INSERT INTO ml_itsec_logs VALUES("34272","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"43018\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"184.75.221.43\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:84.0) Gecko/20100101 Firefox/84.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644833209.9336\";s:12:\"REQUEST_TIME\";s:10:\"1644833209\";}}","notice","2022-02-14 10:06:50","2022-02-14 10:06:49","7048248","7101056","https://messagetech.com/xmlrpc.php","1","0","184.75.221.43");
INSERT INTO ml_itsec_logs VALUES("34273","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"37598\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"104.149.155.226\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36 OPR/75.0.3969.218\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644876520.5809\";s:12:\"REQUEST_TIME\";s:10:\"1644876520\";}}","notice","2022-02-14 22:08:40","2022-02-14 22:08:40","7058928","7123920","https://messagetech.com/xmlrpc.php","1","0","104.149.155.226");
INSERT INTO ml_itsec_logs VALUES("34274","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"2256\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.100.246\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"faq.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:133:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/69.0.3497.81 Chrome/69.0.3497.81 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:19:\"faq.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:19:\"faq.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://faq.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644888645.7763\";s:12:\"REQUEST_TIME\";s:10:\"1644888645\";}}","notice","2022-02-15 01:30:45","2022-02-15 01:30:45","7058976","7123968","https://faq.messagetech.com/xmlrpc.php","1","0","185.220.100.246");
INSERT INTO ml_itsec_logs VALUES("34275","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"7627\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"187.190.136.155\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"202\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900819.9898\";s:12:\"REQUEST_TIME\";s:10:\"1644900819\";}}","notice","2022-02-15 04:53:40","2022-02-15 04:53:40","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","187.190.136.155");
INSERT INTO ml_itsec_logs VALUES("34276","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54477\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"113.191.67.63\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900826.6502\";s:12:\"REQUEST_TIME\";s:10:\"1644900826\";}}","notice","2022-02-15 04:53:46","2022-02-15 04:53:46","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","113.191.67.63");
INSERT INTO ml_itsec_logs VALUES("34277","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"58384\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"41.220.112.214\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900830.6156\";s:12:\"REQUEST_TIME\";s:10:\"1644900830\";}}","notice","2022-02-15 04:53:50","2022-02-15 04:53:50","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","41.220.112.214");
INSERT INTO ml_itsec_logs VALUES("34278","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"37483\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"60.50.88.239\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"202\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900834.5091\";s:12:\"REQUEST_TIME\";s:10:\"1644900834\";}}","notice","2022-02-15 04:53:55","2022-02-15 04:53:54","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","60.50.88.239");
INSERT INTO ml_itsec_logs VALUES("34279","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51165\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"49.165.9.52\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900839.4794\";s:12:\"REQUEST_TIME\";s:10:\"1644900839\";}}","notice","2022-02-15 04:53:59","2022-02-15 04:53:59","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","49.165.9.52");
INSERT INTO ml_itsec_logs VALUES("34280","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"44636\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"78.180.63.112\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900851.4291\";s:12:\"REQUEST_TIME\";s:10:\"1644900851\";}}","notice","2022-02-15 04:54:11","2022-02-15 04:54:11","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","78.180.63.112");
INSERT INTO ml_itsec_logs VALUES("34281","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53191\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"121.138.88.227\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900857.7738\";s:12:\"REQUEST_TIME\";s:10:\"1644900857\";}}","notice","2022-02-15 04:54:17","2022-02-15 04:54:17","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","121.138.88.227");
INSERT INTO ml_itsec_logs VALUES("34282","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"62097\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"83.234.123.252\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900860.8182\";s:12:\"REQUEST_TIME\";s:10:\"1644900860\";}}","notice","2022-02-15 04:54:20","2022-02-15 04:54:20","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","83.234.123.252");
INSERT INTO ml_itsec_logs VALUES("34283","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"11349\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"5.25.161.137\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900863.6812\";s:12:\"REQUEST_TIME\";s:10:\"1644900863\";}}","notice","2022-02-15 04:54:24","2022-02-15 04:54:23","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","5.25.161.137");
INSERT INTO ml_itsec_logs VALUES("34284","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54600\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"182.228.195.67\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644900866.8911\";s:12:\"REQUEST_TIME\";s:10:\"1644900866\";}}","notice","2022-02-15 04:54:27","2022-02-15 04:54:26","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","182.228.195.67");
INSERT INTO ml_itsec_logs VALUES("34285","0","lockout","user-lockout::3","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:3;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-14 23:54:26\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-15 04:54:26\";s:14:\"lockout_expire\";s:19:\"2022-02-15 00:09:26\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-15 05:09:26\";s:12:\"lockout_user\";i:3;}","action","2022-02-15 04:54:27","2022-02-15 04:54:26","7092192","7119456","https://messagetech.com/xmlrpc.php","1","0","182.228.195.67");
INSERT INTO ml_itsec_logs VALUES("34286","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"49240\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"197.238.218.227\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644901768.3122\";s:12:\"REQUEST_TIME\";s:10:\"1644901768\";}}","notice","2022-02-15 05:09:29","2022-02-15 05:09:28","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","197.238.218.227");
INSERT INTO ml_itsec_logs VALUES("34287","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54484\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"20.58.182.37\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644919209.9353\";s:12:\"REQUEST_TIME\";s:10:\"1644919209\";}}","notice","2022-02-15 10:00:09","2022-02-15 10:00:09","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","20.58.182.37");
INSERT INTO ml_itsec_logs VALUES("34288","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"61048\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"20.58.182.37\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"485\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644919210.9954\";s:12:\"REQUEST_TIME\";s:10:\"1644919210\";}}","notice","2022-02-15 10:00:11","2022-02-15 10:00:11","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","20.58.182.37");
INSERT INTO ml_itsec_logs VALUES("34289","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"65434\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"20.58.182.37\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644919213.2014\";s:12:\"REQUEST_TIME\";s:10:\"1644919213\";}}","notice","2022-02-15 10:00:13","2022-02-15 10:00:13","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","20.58.182.37");
INSERT INTO ml_itsec_logs VALUES("34290","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"54401\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"20.58.182.37\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"484\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644919214.4607\";s:12:\"REQUEST_TIME\";s:10:\"1644919214\";}}","notice","2022-02-15 10:00:14","2022-02-15 10:00:14","7062384","7127376","https://www.messagetech.com//xmlrpc.php","1","0","20.58.182.37");
INSERT INTO ml_itsec_logs VALUES("34291","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:49:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:12:\"//xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60253\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"20.58.182.37\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:19:\"www.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:14:\"CONTENT_LENGTH\";s:3:\"487\";s:12:\"CONTENT_TYPE\";s:15:\"application/xml\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:15:\"HTTP_KEEP_ALIVE\";s:3:\"300\";s:9:\"HTTP_HOST\";s:19:\"www.messagetech.com\";s:11:\"SSL_TLS_SNI\";s:19:\"www.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:38:\"https://www.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644919215.498\";s:12:\"REQUEST_TIME\";s:10:\"1644919215\";}}","notice","2022-02-15 10:00:15","2022-02-15 10:00:15","7062392","7127384","https://www.messagetech.com//xmlrpc.php","1","0","20.58.182.37");
INSERT INTO ml_itsec_logs VALUES("34292","0","lockout","host-lockout::20.58.182.37","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:12:\"20.58.182.37\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-15 05:00:15\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-15 10:00:15\";s:14:\"lockout_expire\";s:19:\"2022-02-15 05:15:15\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-15 10:15:15\";s:12:\"lockout_host\";s:12:\"20.58.182.37\";}","action","2022-02-15 10:00:15","2022-02-15 10:00:15","7106568","7134176","https://www.messagetech.com//xmlrpc.php","1","0","20.58.182.37");
INSERT INTO ml_itsec_logs VALUES("34293","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"53438\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"135.125.205.142\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:22:\"client.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/11.1.2 Safari/605.1.15\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:22:\"client.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:22:\"client.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:41:\"https://client.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644920350.4313\";s:12:\"REQUEST_TIME\";s:10:\"1644920350\";}}","notice","2022-02-15 10:19:10","2022-02-15 10:19:10","7059024","7124000","https://client.messagetech.com/xmlrpc.php","1","0","135.125.205.142");
INSERT INTO ml_itsec_logs VALUES("34294","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"32488\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"185.220.102.244\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644928498.942\";s:12:\"REQUEST_TIME\";s:10:\"1644928498\";}}","notice","2022-02-15 12:34:59","2022-02-15 12:34:58","7058864","7123856","https://messagetech.com/xmlrpc.php","1","0","185.220.102.244");
INSERT INTO ml_itsec_logs VALUES("34295","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"7550\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"185.220.101.69\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.43 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36 OPR/73.0.3856.344\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"229\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644952478.262\";s:12:\"REQUEST_TIME\";s:10:\"1644952478\";}}","notice","2022-02-15 19:14:38","2022-02-15 19:14:38","7045184","7094768","https://messagetech.com/xmlrpc.php","1","0","185.220.101.69");
INSERT INTO ml_itsec_logs VALUES("34296","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:223:\"<strong>ERROR</strong>: The password you entered for the username <strong>admin</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:5:\"admin\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"36741\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"45.153.160.139\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:20:\"blog.messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:135:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/68.0.3440.106 Chrome/68.0.3440.106 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:20:\"blog.messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"226\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:20:\"blog.messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:39:\"https://blog.messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644968680.6142\";s:12:\"REQUEST_TIME\";s:10:\"1644968680\";}}","notice","2022-02-15 23:44:40","2022-02-15 23:44:40","7058976","7123968","https://blog.messagetech.com/xmlrpc.php","1","0","45.153.160.139");
INSERT INTO ml_itsec_logs VALUES("34297","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:48:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1545\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"193.239.232.102\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:84.0) Gecko/20100101 Firefox/84.0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:14:\"CONTENT_LENGTH\";s:3:\"231\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644969200.5506\";s:12:\"REQUEST_TIME\";s:10:\"1644969200\";}}","notice","2022-02-15 23:53:20","2022-02-15 23:53:20","7048248","7101056","https://messagetech.com/xmlrpc.php","1","0","193.239.232.102");
INSERT INTO ml_itsec_logs VALUES("34298","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:4:\"1506\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"49.150.96.35\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991734.4402\";s:12:\"REQUEST_TIME\";s:10:\"1644991734\";}}","notice","2022-02-16 06:08:54","2022-02-16 06:08:54","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","49.150.96.35");
INSERT INTO ml_itsec_logs VALUES("34299","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"64937\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"102.39.90.232\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"204\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991740.0028\";s:12:\"REQUEST_TIME\";s:10:\"1644991740\";}}","notice","2022-02-16 06:09:00","2022-02-16 06:09:00","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","102.39.90.232");
INSERT INTO ml_itsec_logs VALUES("34300","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"51230\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"94.68.133.39\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"203\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991744.2358\";s:12:\"REQUEST_TIME\";s:10:\"1644991744\";}}","notice","2022-02-16 06:09:04","2022-02-16 06:09:04","7065672","7118480","https://messagetech.com/xmlrpc.php","1","0","94.68.133.39");
INSERT INTO ml_itsec_logs VALUES("34301","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52082\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"102.223.24.178\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"203\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991748.5959\";s:12:\"REQUEST_TIME\";s:10:\"1644991748\";}}","notice","2022-02-16 06:09:08","2022-02-16 06:09:08","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","102.223.24.178");
INSERT INTO ml_itsec_logs VALUES("34302","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"30373\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"102.119.180.169\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"204\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991754.0495\";s:12:\"REQUEST_TIME\";s:10:\"1644991754\";}}","notice","2022-02-16 06:09:14","2022-02-16 06:09:14","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","102.119.180.169");
INSERT INTO ml_itsec_logs VALUES("34303","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"34373\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"103.129.77.144\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"205\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991757.6712\";s:12:\"REQUEST_TIME\";s:10:\"1644991757\";}}","notice","2022-02-16 06:09:17","2022-02-16 06:09:17","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","103.129.77.144");
INSERT INTO ml_itsec_logs VALUES("34304","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"56759\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:12:\"36.70.120.32\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991775.0526\";s:12:\"REQUEST_TIME\";s:10:\"1644991775\";}}","notice","2022-02-16 06:09:35","2022-02-16 06:09:35","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","36.70.120.32");
INSERT INTO ml_itsec_logs VALUES("34305","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"64521\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"186.138.44.51\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:14:\"1644991779.464\";s:12:\"REQUEST_TIME\";s:10:\"1644991779\";}}","notice","2022-02-16 06:09:39","2022-02-16 06:09:39","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","186.138.44.51");
INSERT INTO ml_itsec_logs VALUES("34306","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"61288\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:11:\"182.1.51.69\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"206\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991786.4281\";s:12:\"REQUEST_TIME\";s:10:\"1644991786\";}}","notice","2022-02-16 06:09:46","2022-02-16 06:09:46","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","182.1.51.69");
INSERT INTO ml_itsec_logs VALUES("34307","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"48094\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"105.104.102.111\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"207\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644991796.8851\";s:12:\"REQUEST_TIME\";s:10:\"1644991796\";}}","notice","2022-02-16 06:09:57","2022-02-16 06:09:56","7051280","7104088","https://messagetech.com/xmlrpc.php","1","0","105.104.102.111");
INSERT INTO ml_itsec_logs VALUES("34308","0","lockout","user-lockout::2","a:13:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";b:0;s:7:\"user_id\";i:2;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2022-02-16 01:09:56\";s:17:\"lockout_start_gmt\";s:19:\"2022-02-16 06:09:56\";s:14:\"lockout_expire\";s:19:\"2022-02-16 01:24:56\";s:18:\"lockout_expire_gmt\";s:19:\"2022-02-16 06:24:56\";s:12:\"lockout_user\";i:2;}","action","2022-02-16 06:09:57","2022-02-16 06:09:56","7095360","7122264","https://messagetech.com/xmlrpc.php","1","0","105.104.102.111");
INSERT INTO ml_itsec_logs VALUES("34309","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60938\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"202.80.212.210\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"204\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644992699.2591\";s:12:\"REQUEST_TIME\";s:10:\"1644992699\";}}","notice","2022-02-16 06:24:59","2022-02-16 06:24:59","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","202.80.212.210");
INSERT INTO ml_itsec_logs VALUES("34310","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:228:\"<strong>ERROR</strong>: The password you entered for the username <strong>alexandria</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:10:\"alexandria\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52468\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:15:\"201.123.198.244\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"203\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1644992702.4704\";s:12:\"REQUEST_TIME\";s:10:\"1644992702\";}}","notice","2022-02-16 06:25:02","2022-02-16 06:25:02","7051272","7104080","https://messagetech.com/xmlrpc.php","1","0","201.123.198.244");
INSERT INTO ml_itsec_logs VALUES("34311","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"21542\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"189.202.95.194\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"203\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006433.8243\";s:12:\"REQUEST_TIME\";s:10:\"1645006433\";}}","notice","2022-02-16 10:13:53","2022-02-16 10:13:53","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","189.202.95.194");
INSERT INTO ml_itsec_logs VALUES("34312","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"63032\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"184.22.142.40\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"201\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006449.3636\";s:12:\"REQUEST_TIME\";s:10:\"1645006449\";}}","notice","2022-02-16 10:14:09","2022-02-16 10:14:09","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","184.22.142.40");
INSERT INTO ml_itsec_logs VALUES("34313","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52262\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"92.126.204.155\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006452.0174\";s:12:\"REQUEST_TIME\";s:10:\"1645006452\";}}","notice","2022-02-16 10:14:12","2022-02-16 10:14:12","7062512","7112096","https://messagetech.com/xmlrpc.php","1","0","92.126.204.155");
INSERT INTO ml_itsec_logs VALUES("34314","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"26957\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"140.213.190.87\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006455.8032\";s:12:\"REQUEST_TIME\";s:10:\"1645006455\";}}","notice","2022-02-16 10:14:15","2022-02-16 10:14:15","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","140.213.190.87");
INSERT INTO ml_itsec_logs VALUES("34315","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"52442\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"177.75.205.50\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006459.7256\";s:12:\"REQUEST_TIME\";s:10:\"1645006459\";}}","notice","2022-02-16 10:14:19","2022-02-16 10:14:19","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","177.75.205.50");
INSERT INTO ml_itsec_logs VALUES("34316","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"55125\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"78.186.245.71\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006462.2248\";s:12:\"REQUEST_TIME\";s:10:\"1645006462\";}}","notice","2022-02-16 10:14:22","2022-02-16 10:14:22","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","78.186.245.71");
INSERT INTO ml_itsec_logs VALUES("34317","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"59580\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:14:\"197.238.143.58\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006464.8547\";s:12:\"REQUEST_TIME\";s:10:\"1645006464\";}}","notice","2022-02-16 10:14:25","2022-02-16 10:14:24","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","197.238.143.58");
INSERT INTO ml_itsec_logs VALUES("34318","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"59985\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"200.41.233.98\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"200\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006472.4501\";s:12:\"REQUEST_TIME\";s:10:\"1645006472\";}}","notice","2022-02-16 10:14:32","2022-02-16 10:14:32","7048112","7097696","https://messagetech.com/xmlrpc.php","1","0","200.41.233.98");
INSERT INTO ml_itsec_logs VALUES("34319","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"mlinkers\";s:7:\"user_id\";i:3;s:6:\"SERVER\";a:52:{s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:11:\"/xmlrpc.php\";s:14:\"FREETDSLOCALES\";s:0:\"\";s:11:\"FREETDSCONF\";s:0:\"\";s:15:\"OPENSSL_ENGINES\";s:31:\"/opt/bitnami/common/lib/engines\";s:12:\"OPENSSL_CONF\";s:39:\"/opt/bitnami/common/openssl/openssl.cnf\";s:13:\"SSL_CERT_FILE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:14:\"CURL_CA_BUNDLE\";s:52:\"/opt/bitnami/common/openssl/certs/curl-ca-bundle.crt\";s:8:\"LDAPCONF\";s:42:\"/opt/bitnami/common/etc/openldap/ldap.conf\";s:6:\"GS_LIB\";s:0:\"\";s:24:\"MAGICK_CODER_MODULE_PATH\";s:0:\"\";s:21:\"MAGICK_CONFIGURE_PATH\";s:0:\"\";s:11:\"MAGICK_HOME\";s:0:\"\";s:4:\"PATH\";s:155:\"/opt/bitnami/varnish/bin:/opt/bitnami/sqlite/bin:/opt/bitnami/php/bin:/opt/bitnami/mysql/bin:/opt/bitnami/apache2/bin:/opt/bitnami/common/bin:/usr/bin:/bin\";s:4:\"USER\";s:6:\"daemon\";s:4:\"HOME\";s:9:\"/usr/sbin\";s:11:\"SCRIPT_NAME\";s:11:\"/xmlrpc.php\";s:12:\"QUERY_STRING\";s:0:\"\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:11:\"REMOTE_PORT\";s:5:\"60605\";s:15:\"SCRIPT_FILENAME\";s:45:\"/opt/bitnami/apps/wordpress/htdocs/xmlrpc.php\";s:12:\"SERVER_ADMIN\";s:15:\"you@example.com\";s:21:\"CONTEXT_DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:14:\"CONTEXT_PREFIX\";s:0:\"\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:13:\"DOCUMENT_ROOT\";s:34:\"/opt/bitnami/apps/wordpress/htdocs\";s:11:\"REMOTE_ADDR\";s:13:\"186.52.161.77\";s:11:\"SERVER_PORT\";s:3:\"443\";s:11:\"SERVER_ADDR\";s:9:\"11.0.50.5\";s:11:\"SERVER_NAME\";s:15:\"messagetech.com\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:15:\"LD_LIBRARY_PATH\";s:385:\"/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:/opt/bitnami/varnish/lib:/opt/bitnami/varnish/lib/varnish:/opt/bitnami/varnish/lib/varnish/vmods:/opt/bitnami/sqlite/lib:/opt/bitnami/mysql/lib:/opt/bitnami/apache2/lib:/opt/bitnami/common/lib:\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:9:\"HTTP_HOST\";s:15:\"messagetech.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"199\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:11:\"SSL_TLS_SNI\";s:15:\"messagetech.com\";s:5:\"HTTPS\";s:2:\"on\";s:14:\"DISABLE_BANNER\";s:3:\"YES\";s:10:\"SCRIPT_URI\";s:34:\"https://messagetech.com/xmlrpc.php\";s:10:\"SCRIPT_URL\";s:11:\"/xmlrpc.php\";s:9:\"FCGI_ROLE\";s:9:\"RESPONDER\";s:8:\"PHP_SELF\";s:11:\"/xmlrpc.php\";s:18:\"REQUEST_TIME_FLOAT\";s:15:\"1645006477.5039\";s:12:\"REQUEST_TIME\";s:10:\"1645006477\";}}","notice","2022-02-16 10:14:37","2022-02-16 10:14:37","7048080","7097664","https://messagetech.com/xmlrpc.php","1","0","186.52.161.77");
INSERT INTO ml_itsec_logs VALUES("34320","0","brute_force","invalid-login","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:6:\"xmlrpc\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:226:\"<strong>ERROR</strong>: The password you entered for the username <strong>mlinkers</strong> is incorrect. <a href=\"https://www.messagetech.com/wp-login.php?itsec-hb-token=mti_manage&action=lostpassword\">Lost your password?</a>\";}}s:10:\"error_data\