<?php
/**
 * 'logo_filter' Shortcode
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Function to handle the `logo_filter` shortcode
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
function wpls_pro_logo_filter( $atts, $content ) {

	// Shortcode Parameters
	$atts = shortcode_atts(array(
		'design'				=> 'design-1',
		'cat_id' 				=> '',
		'cat_name' 				=> '',
		'order'					=> 'DESC',
		'orderby'				=> 'date',
		'grid' 					=> 4,
		'link_target'			=> 'self',
		'show_title' 			=> 'true',
		'image_size' 			=> 'full',
		'cat_limit'				=> 0,
		'cat_order'				=> 'asc',
		'cat_orderby'			=> 'name',
		'exclude_cat'			=> array(),
		'tooltip'				=> 'false',
		'include_cat_child'		=> 'true',
		'all_filter_text'		=> '',
		'content_words_limit' 	=> 20,
		'content_tail'			=> '...',
		'extra_class'			=> '',
		), $atts, 'logo_filter' );

	$shortcode_designs				= wpls_pro_logo_designs();
	$atts['unique'] 				= wpls_pro_get_unique();
	$atts['design'] 				= array_key_exists( trim($atts['design']), $shortcode_designs ) ? $atts['design'] 		: 'design-1';
	$atts['link_target'] 			= ($atts['link_target'] == 'blank') 			? '_blank' 								: '_self';
	$atts['order'] 					= (strtolower($atts['order']) == 'asc' ) 		? 'ASC' 								: 'DESC';
	$atts['orderby']				= !empty($atts['orderby']) 						? $atts['orderby'] 						: 'date';
	$atts['grid']					= (!empty($atts['grid']) && $atts['grid'] <= 12) ? $atts['grid'] 						: '4';
	$atts['grid_class']				= ($atts['grid'] <= 12 ) 						? ('wpls-col-'.($atts['grid'])) 		: 'wpls-col-4';
	$atts['cat_id']					= (!empty($atts['cat_id']))						? explode(',',$atts['cat_id']) 			: '';
	$atts['cat_limit']				= !empty($atts['cat_limit']) 					? $atts['cat_limit'] 					: 0;
	$atts['cat_order'] 				= (strtolower($atts['cat_order']) == 'asc' ) 	? 'ASC' 								: 'DESC';
	$atts['cat_orderby']			= !empty($atts['cat_orderby']) 					? $atts['cat_orderby'] 					: 'name';
	$atts['exclude_cat'] 			= !empty($atts['exclude_cat'])					? explode(',', $atts['exclude_cat']) 	: array();
	$atts['tooltip'] 				= ($atts['tooltip'] == "true") 					? 'true' 								: 'false';
	$atts['include_cat_child']		= ($atts['include_cat_child'] == 'false' ) 		? false 								: true;
	$atts['all_filter_text'] 		= !empty($atts['all_filter_text']) 				? $atts['all_filter_text'] 				: __('All', 'logoshowcase');
	$atts['content_words_limit'] 	= !empty( $atts['content_words_limit'] ) 		? $atts['content_words_limit'] 			: 20;
	$atts['extra_class']			= wpls_pro_sanitize_html_classes($atts['extra_class']);
	$atts['content_tail'] 			= html_entity_decode($atts['content_tail']);

	// Extract Shortcode Var
	extract($atts);

	// Enqueus required script
	if($tooltip == 'true') {
		wp_enqueue_script( 'wpos-tooltip-js' );
	}
	wp_enqueue_script( 'wpos-isotope-js' );
	wp_enqueue_script( 'wpls-pro-public-js' );

	// Taking some globals
	global $post;

	// Getting Terms
	$atts['wplsterms'] = get_terms( array(
							'taxonomy' 		=> WPLS_PRO_CAT,
							'hide_empty' 	=> true,
							'fields'		=> 'id=>name',
							'number'		=> $cat_limit,
							'order'			=> $cat_order,
							'orderby'		=> $cat_orderby,
							'include'       => $cat_id,
							'exclude'       => $exclude_cat,
						));

	ob_start();

	// If category is there
	if( !is_wp_error($atts['wplsterms']) && !empty($atts['wplsterms']) ) {

		// Getting ids 
		$logo_cats = array_keys( $atts['wplsterms'] );

		// WP Query Parameters
		$query_args = array(
				'post_type' 			=> WPLS_PRO_POST_TYPE,
				'post_status' 			=> array( 'publish' ),
				'posts_per_page'		=> -1,
				'order'          		=> $order,
				'orderby'        		=> $orderby,
				'ignore_sticky_posts'	=> true,
			);

		// Category Parameter
		if( !empty($logo_cats) ) {

			$query_args['tax_query'] = array( 
											array(
												'taxonomy' 			=> WPLS_PRO_CAT, 
												'field' 			=> 'term_id',
												'terms' 			=> $logo_cats,
												'include_children'	=> $include_cat_child,
											));
		}

		// WP Query
		$logo_query = new WP_Query($query_args);
		
		// If logo post is there
		if( $logo_query->have_posts() ) {

			wpls_get_template( 'filter/loop-start.php', $atts ); // loop start

			while ($logo_query->have_posts()) : $logo_query->the_post();

					$usedcat				= array();
					$postcats 				= get_the_terms($post->ID, WPLS_PRO_CAT);
					$atts['feat_image'] 	= wpls_pro_get_logo_image($post->ID, $image_size);
					$atts['logourl'] 		= get_post_meta( get_the_ID(), 'wplss_slide_link', true );
					$atts['logo_title'] 	= the_title_attribute( array('echo' => false) );
					$tooltip_cls 			= ( $atts['logo_title'] != '' && $tooltip == "true" ) ? 'wpls-tooltip' : '';
					$atts['title_attr']	 	= ($tooltip == 'true') ? 'title="'.$atts['logo_title'].'"' : '';

					// Getting Post Terms
					if( !is_wp_error($postcats) && !empty($postcats) ) {
						foreach ($postcats as $postcat) {
							$usedcat[] = 'wpls-cat-'.$postcat->term_id;
						}
					}
					$category_class = !empty($usedcat) ? implode(' ', $usedcat) : null;
					$atts['cnt_wrp_cls'] = "{$grid_class} wpls-columns {$tooltip_cls} {$category_class}";

					// Skip if image not found & Include shortcode html file
					if( !empty($atts['feat_image']) ) {

						// loop designs
						wpls_get_template( "filter/{$design}.php", $atts, null, null, "designs/{$design}.php" );

					}	

				endwhile;

				wpls_get_template( 'filter/loop-end.php', $atts ); // loop end

		} // End of have post

	} else {
		echo '<p><strong>'. __('logo_filter shortcode requires some category to make it work. Please create some category and assign it to respective logo.') .'</strong></p>';
	} // End of category check

	wp_reset_postdata(); // Reset WP Query

	$content .= ob_get_clean();
	return $content;
}

// 'logo_filter' Shortcode
add_shortcode('logo_filter', 'wpls_pro_logo_filter');