<?php
/**
 * Shortcode Preview
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.3.4
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$authenticated          = false;
$registered_shortcodes  = wpls_pro_registered_shortcodes();

// Getting shortcode value
if( !empty( $_POST['wpls_customizer_shrt'] ) ) {
	$shortcode_val = wpls_pro_clean_html( $_POST['wpls_customizer_shrt'] );
} elseif ( !empty($_GET['shortcode']) && isset( $registered_shortcodes[ $_GET['shortcode'] ] ) ) {
	$shortcode_val = '['.$_GET['shortcode'].']';
} else {
	$shortcode_val = '';
}

// For authentication so no one can use page via URL
if( isset($_SERVER['HTTP_REFERER']) ) {
	$url_query  = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_QUERY);
	parse_str( $url_query, $referer );

	if( !empty($referer['page']) && $referer['page'] == 'wpls-shrt-mapper' ) {
		$authenticated = true;
	}
}

// Check Authentication else exit
if( !$authenticated ) {
	wp_die( __('Sorry, you are not allowed to access this page.', 'logoshowcase') );
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta http-equiv="Imagetoolbar" content="No" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title><?php _e("Shortcode Preview", "logoshowcase"); ?></title>

		<?php wp_print_styles('common'); ?>
		<link rel="stylesheet" href="<?php echo WPLS_PRO_URL; ?>assets/css/slick.css?ver=<?php echo WPLS_PRO_VERSION; ?>" type="text/css" />
		<link rel="stylesheet" href="<?php echo WPLS_PRO_URL; ?>assets/css/animate.min.css?ver=<?php echo WPLS_PRO_VERSION; ?>" type="text/css" />
		<link rel="stylesheet" href="<?php echo WPLS_PRO_URL; ?>assets/css/wpls-pro-public.css?ver=<?php echo WPLS_PRO_VERSION; ?>" type="text/css" />
		<?php do_action( 'wpls_shortcode_preview_head', $shortcode_val ); ?>

		<style type="text/css">
			body{background: #fff; overflow-x: hidden;}
			.wpls-customizer-container{padding:0 16px;}
			.wpls-customizer-container a[href^="http"]{cursor:not-allowed !important;}
			a:focus, a:active{box-shadow: none; outline: none;}
			.wpls-link-notice{display: none; position: fixed; color: #a94442; background-color: #f2dede; border:1px solid #ebccd1; max-width:300px; width: 100%; left:0; right:0; bottom:30%; margin:auto; padding:10px; text-align: center; z-index: 1050;}
		</style>
		<?php wp_print_scripts( array('jquery', 'imagesloaded') ); ?>
	</head>
	<body>
		<div id="wpls-customizer-container" class="wpls-customizer-container">
			<?php if( $shortcode_val ) {
				echo do_shortcode( $shortcode_val );
			} ?>
		</div>
		<div class="wpls-link-notice"><?php _e('Sorry, You can not visit the link in preview', 'logoshowcase'); ?></div>
		
		<script type='text/javascript'>
		//<![CDATA[
		var WplsPro = <?php echo wp_json_encode(array(
															'is_mobile'         =>  (wp_is_mobile()) ? 1 : 0,
															'is_rtl'            =>  (is_rtl()) ? 1 : 0,
															'tooltip_theme'     =>  wpls_pro_get_option('tooltip_theme','punk'),
															'tooltip_animation' =>  wpls_pro_get_option('tooltip_animation','grow'),
															'tooltip_behavior'  =>  wpls_pro_get_option('tooltip_behavior','hover'),
															'tooltip_arrow'     =>  wpls_pro_get_option('tooltip_arrow','true'),
															'tooltip_delay'     =>  wpls_pro_get_option('tooltip_delay'),
															'tooltip_distance'  =>  wpls_pro_get_option('tooltip_distance','6'),
															'tooltip_maxwidth'  =>  wpls_pro_get_option('tooltip_maxwidth'),
															'tooltip_minwidth'  =>  wpls_pro_get_option('tooltip_minwidth'),
														)); ?>;
		//]]>
		</script>
		<script type="text/javascript" src="<?php echo WPLS_PRO_URL; ?>assets/js/slick.min.js?ver=<?php echo WPLS_PRO_VERSION; ?>"></script>
		<script type="text/javascript" src="<?php echo WPLS_PRO_URL; ?>assets/js/tooltipster.min.js?ver=<?php echo WPLS_PRO_VERSION; ?>"></script>
		<script type="text/javascript" src="<?php echo WPLS_PRO_URL; ?>assets/js/isotope.pkgd.min.js?ver=<?php echo WPLS_PRO_VERSION; ?>"></script>
		<script type="text/javascript" src="<?php echo WPLS_PRO_URL; ?>assets/js/wpls-pro-public.js?ver=<?php echo WPLS_PRO_VERSION; ?>"></script>
		<?php do_action( 'wpls_shortcode_preview_footer', $shortcode_val ); ?>
		<script type="text/javascript">
		jQuery(document).ready(function($) {
			$(document).on('click', 'a', function(event) {
				
				var href_val = $(this).attr('href');

				if( href_val.indexOf('javascript:') < 0 ) {
					$('.wpls-link-notice').fadeIn();
				}
				event.preventDefault();

				setTimeout(function() {
					$(".wpls-link-notice").fadeOut('normal');
				}, 4000 );
			});
		});
		</script>
	</body>
</html>