<?php 
/*

* Template Name: Services

*/

get_header(); ?>

<!--inner content start-->

<div class="inner-content">
  <div class="container">
    <?php

  if (have_posts()) :

  	while (have_posts()) :

		the_post();

		?>
    <div class="servicesImg"> <img src="<?php the_post_thumbnail_url(); ?>"> </div>
    <div class="pageContent">
      <h1 class="main-title">
        <?php the_title(); ?>
      </h1>
      <?php the_content(); ?>
      <?php

		endwhile;

	endif;

	?>
    </div>
  </div>
</div>

<div class="container">
    <div class="counterwraper row">

        <?php if ( have_rows('counter_section') ) : ?>
            <?php while ( have_rows('counter_section') ) : the_row(); ?>

                <?php 
                    $num  = get_sub_field('counter_number'); 
                    $text = get_sub_field('counter_text'); 
                ?>

                <div class="col-lg-4">
                    <div class="counterbox">
                        <!-- Start at 0; raw number in data-count -->
                        <div class="counternumber" data-count="<?php echo esc_attr($num); ?>">0</div>
                        <div class="countertext"><?php echo esc_html($text); ?></div>
                    </div>
                </div>

            <?php endwhile; ?>
        <?php endif; ?>

    </div>
</div>





<div class="features-section">

    <?php if( have_rows('features_section') ): ?>
        <?php while( have_rows('features_section') ): the_row(); ?>

            <div class="feature-box">

                <div class="feature-icon">
                    <i class="<?php the_sub_field('icon_class'); ?>" aria-hidden="true"></i>
                </div>

                <div class="fetwrap">
                    <h3><?php the_sub_field('title'); ?></h3>
                    <p><?php the_sub_field('description'); ?></p>
                </div>

            </div>

        <?php endwhile; ?>
    <?php endif; ?>

</div>


<!--inner content end--> 

<!--Outbound IVR Features start-->
<div class="container">
<div class="outbound-features features">  
    <div class="row">
      <div class="col-md-5">
        <div class="feature-image">
          <?php $services_side_image	=	get_field('services_side_image'); ?>
          <img src="<?php echo $services_side_image['url']; ?>" alt="<?php echo $services_side_image['alt']; ?>" /> </div>
      </div>
      <div class="col-md-7">
        <div class="main-title">
          <?php the_field('services_heading'); ?>
        </div>
        <ul class="opportunity-links">
          <?php the_field('services_list'); ?>
        </ul>
      </div>
    </div>
  </div>
</div>

<!--Outbound IVR Features start-->

<script>
document.addEventListener("DOMContentLoaded", function() {
    const counters = document.querySelectorAll('.counternumber');

    counters.forEach(counter => {
        const target = +counter.getAttribute('data-count'); // target number
        let count = 0;

        const updateCount = () => {
            const increment = Math.ceil(target / 200); // adjust speed
            count += increment;

            if (count >= target) count = target;

            counter.innerText = count.toLocaleString() + (target >= 100 ? "'s" : '');

            if (count < target) {
                requestAnimationFrame(updateCount);
            }
        };

        updateCount();
    });
});
</script>


<?php get_footer(); ?>
