<div class="sidebar"> 

  <!-- Search -->

  <div class="widget">

    <h5 class="widget-title">Search</h5>

    <div class="search">

      <form role="search" method="get" class="search-form" action="<?php echo home_url( '/' ); ?>">

        <input type="text" class="form-control" placeholder="<?php echo esc_attr_x( 'Search …', 'placeholder' ) ?>" value="<?php echo get_search_query() ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label' ) ?>" />

        <button type="submit" class="btn"><i class="fa fa-search"></i></button>

      </form>

    </div>

  </div>

  <!-- Categories -->

  <div class="widget">

    <h5 class="widget-title">Categories</h5>

    <ul class="categories">

      <?php wp_list_categories( array(

            'orderby'    => 'name',

            'title_li' => ''

        ) ); ?>

    </ul>

  </div>

  

  <!-- Archives Posts -->

  <div class="widget">

    <h5 class="widget-title">Archives</h5>

    <ul class="mtarchive">

      <?php wp_get_archives( array( 'type' => 'monthly', 'limit' => 12) ); ?>

    </ul>

  </div>

  

  <!-- Tags -->

  <div class="widget">

    <h5 class="widget-title">Tags</h5>

    <?php

        $tags = get_tags();

        $html = '<ul class="tags">';

        foreach ( $tags as $tag ) {

            $tag_link = get_tag_link( $tag->term_id );

            $html .= "<a href='{$tag_link}' title='{$tag->name} Tag'>";

            $html .= "{$tag->name}</a>";

        }

        $html .= '</ul>';

        echo $html;

       ?>

  </div>

</div>