<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
<title></title>

<link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicon.ico" type="image/x-icon">

<!-- Bootstrap -->
<link href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/css/font-awesome-6.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/rs-plugin/css/settings.css">
<link href="<?php echo get_template_directory_uri(); ?>/css/owl.carousel.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css?family=Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900" rel="stylesheet">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/style.css">



<!-- HTML5 shim and Respond.js for IE8 support -->
<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<!--header start-->

<div class="header-wrap">
  <div class="container">
    <div class="row align-items-center">

      <div class="col-lg-2 col-md-3">
        
        <div class="logo">
          <a href="<?php echo site_url(); ?>/">
            <?php $header_logo = get_field('header_logo','option'); ?>
            <img src="<?php echo $header_logo['url']; ?>" alt="<?php echo $header_logo['alt']; ?>" />
          </a>
        </div>

        <div class="navbar-header">
          <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
        </div>

      </div>

      <div class="col-lg-10 col-md-9">
        <div class="navigationwrape">
          <nav class="navbar navbar-expand-lg" role="navigation">
            <div class="collapse navbar-collapse" id="navbarNav">
            <button class="close-toggler" type="button" data-toggle="offcanvas"> <span><i class="fas fa-times-circle" aria-hidden="true"></i></span> </button>

              <?php wp_nav_menu( array(
                'theme_location' => 'main_nav',
                'container'      => false,
                'items_wrap'     => '<ul class="navbar-nav">%3$s</ul>'
              ) ); ?>
            </div>
          </nav>

          <div class="topcontactinfo">
          <div class="phone">
            <?php
              $header_phone_number = get_field('header_phone_number','option');
              $href_phone_header = preg_replace("/[^0-9]/", "", $header_phone_number);
            ?>
            
            Call Us! <a href="tel:<?php the_field('header_phone_number','option'); ?>">
              <?php the_field('header_phone_number','option'); ?>
            </a>
          </div>

          <div class="client-btn">
            <a href="<?php the_field('header_client_access_link','option'); ?>" target="_blank">Client Access</a>
          </div>
        </div>

        </div>


      </div>


    </div>
  </div>
</div>

<!--header end-->
