<?php

/* Create main options page and its sub pages */
if (function_exists('acf_set_options_page_title')) {
    acf_set_options_page_title(__('MTI Options'));
}

if (function_exists('acf_add_options_sub_page')) {
    acf_add_options_sub_page('General');
    acf_add_options_sub_page('Home Page');
    // acf_add_options_sub_page('Home Page Logos');
    acf_add_options_sub_page('Technology Page');
    acf_add_options_sub_page('Developer Page');
    acf_add_options_sub_page('SMS Services Page');
    acf_add_options_sub_page('APIs Page');
    acf_add_options_sub_page('Social Links');
}

/* Register Menus */
register_nav_menus(array(
    'main_nav'                   => 'Main Menu',
    'footer_ivr_services_nav'    => 'Footer IVR Services Menu',
    'footer_technology_nav'      => 'Footer Technology Menu',
    'footer_about_mti_nav'       => 'Footer About MTI Menu',
    'footer_contact_options_nav' => 'Footer Contact Options Menu',
    'bottom_footer_nav'          => 'Bottom Footer Menu'
));

/* Pass Google map API key to ACF backend */
function my_acf_google_map_api($api)
{
    $api['key'] = 'AIzaSyDUVCfNc3TErzE2qG8Znon0VrHwgmmIJ4E';
    return $api;
}
add_filter('acf/fields/google_map/api', 'my_acf_google_map_api');

/* Add Featured Image support */
add_theme_support('post-thumbnails');

/* Load FontAwesome 4 */
function force_load_fontawesome_4()
{
    wp_enqueue_style(
        'font-awesome-4',
        'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css',
        array(),
        '4.7.0'
    );
}
add_action('wp_enqueue_scripts', 'force_load_fontawesome_4', 999);

/* Exclude Pages from Search */
function remove_pages_from_search()
{
    global $wp_post_types;
    $wp_post_types['page']->exclude_from_search = true;
}
add_action('init', 'remove_pages_from_search');

/* Register News Post Type */
function create_posttype_news()
{
    register_post_type(
        'news',
        array(
            'labels' => array(
                'name'          => __('News'),
                'singular_name' => __('News')
            ),
            'public'        => true,
            'has_archive'   => true,
            'rewrite'       => array('slug' => 'news', 'with_front' => false),
            'taxonomies'    => array('category'),
            'supports'      => array('title', 'editor', 'thumbnail')
        )
    );
}
add_action('init', 'create_posttype_news');

/* Admin custom CSS */
function admin_style()
{
    wp_enqueue_style('custom', get_template_directory_uri() . '/css/custom.css');
}
add_action('admin_enqueue_scripts', 'admin_style');

flush_rewrite_rules();

/* Register Solution By Industry */
function create_post_type()
{
    register_post_type(
        'acme_product',
        array(
            'labels' => array(
                'name'          => __('Solution By Industry'),
                'singular_name' => __('solution_by_industry')
            ),
            'supports'     => array('title', 'editor', 'publicize', 'thumbnail', 'author', 'post-formats'),
            'public'       => true,
            'has_archive'  => true,
        )
    );
}
add_action('init', 'create_post_type');

/* Register Other Services */
function create_other_services()
{
    register_post_type(
        'other_services',
        array(
            'labels' => array(
                'name'          => __('Other Services'),
                'singular_name' => __('other_services')
            ),
            'supports'     => array('title', 'editor', 'publicize', 'thumbnail', 'author', 'post-formats'),
            'public'       => true,
            'has_archive'  => true,
        )
    );
}
add_action('init', 'create_other_services');

// <!-- //plugins update stop -->







