<?php
/*

 * Template Name: MIT AI IVR

 */

get_header();
?>
<!-- Hero Section -->
<section id="hero" class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="hero-content">

                    <h1><?php
                        $heading = get_field('hero_heading');
                        $highlight = get_field('hero_highlight');
                        if ($heading && $highlight) {
                            echo str_replace('{highlight}', '<span class="highlight">' . esc_html($highlight) . '</span>', esc_html($heading));
                        } else {
                            echo 'Transform <span class="highlight">customer engagement</span> across industries with our AI-Native CX platform.';
                        }
                        ?></h1>
                    <p><?php if (get_field('hero_paragraph_1')): ?>
                    <p><?php the_field('hero_paragraph_1'); ?></p>
                <?php endif; ?></p>
                <?php if (get_field('hero_paragraph_2')): ?>
                    <p><?php the_field('hero_paragraph_2'); ?></p>
                <?php endif; ?>

                <div class="hero-feature-box">
                    <div class="hero-feature-icon">
                     <?php $hero_image = get_field('hero_image'); ?>
<?php if ($hero_image): ?>
    <img src="<?php echo esc_url($hero_image['url']); ?>" alt="<?php echo esc_attr($hero_image['alt']); ?>">
<?php endif; ?>

                    </div>
                    <div class="hero-feature-text">
                        <?php the_field('hero_speak_text'); ?>
                    </div>
                </div>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="hero-form-container">
    <h2>Get in Touch</h2>
            <?php echo do_shortcode('[contact-form-7 id="99f52b3" title="AI IVR"]'); ?>
            </div>
            </div>
        </div>
    </div>
    </div>
</section>
<!-- End Hero Section -->
<!-- Section 2: how-it-works-->
<section id="how-it-works" class="section-white">
    <div class="container">
        <!-- Section Title -->
        <h2 class="section-title"><?php the_field('section_title'); ?></h2>
        <p class="text-center subtitle"><?php the_field('section_subtitle'); ?></p>

        <div class="row">
            <?php
            // Collect all features into an array first
            $all_features = [];
            if (have_rows('features_group')):
                while (have_rows('features_group')): the_row();
                    if (have_rows('features')):
                        while (have_rows('features')): the_row();
                            $all_features[] = [
                                'icon' => get_sub_field('feature_icon'),
                                'title' => get_sub_field('feature_title'),
                                'description' => get_sub_field('feature_description')
                            ];
                        endwhile;
                    endif;
                endwhile;
            endif;

            $total = count($all_features);

            // Loop through features and apply classes conditionally
            foreach ($all_features as $index => $feature):
                if ($index < 3) {
                    // First three features
                    $col_class = 'col-md-6 col-lg-4';
                } else {
                    // Last two features
                    $col_class = 'col-md-6 col-lg-6';
                }
            ?>
                <div class="<?php echo esc_attr($col_class); ?>">
                    <div class="feature-card">
                        <?php if ($feature['icon']): ?>
                            <div class="feature-icon2">
                                <img src="<?php echo esc_url($feature['icon']['url']); ?>" alt="<?php echo esc_attr($feature['icon']['alt']); ?>">
                            </div>
                        <?php endif; ?>
                        <h4><?php echo esc_html($feature['title']); ?></h4>
                        <p><?php echo esc_html($feature['description']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- End Section 2: Benefits -->



<!-- Section 3: Benefits -->
<!-- Section 3: Benefits -->
<?php 
$benefits = get_field('benefits_section');
if($benefits):
?>
<section id="benefits" class="benefits-section">
    <div class="container">
        <div class="text-center">
            <div class="benefits-label">
                <?php echo esc_html($benefits['benefits_label']); ?>
            </div>
            <h2 class="section-title">
                <?php echo esc_html($benefits['section_title']); ?>
            </h2>
        </div>

        <div class="benefits-diagram">
            <div class="row">

                <!-- LEFT SIDE BENEFITS -->
                <div class="col-md-4">
                    <?php if(!empty($benefits['left_side_benefits'])): ?>
                        <?php foreach($benefits['left_side_benefits'] as $item): ?>
                            <div class="benefit-box">
                                <div class="benefit-box-title">
                                    <?php echo esc_html($item['title']); ?>
                                </div>
                                <div class="benefit-box-text">
                                    <?php echo esc_html($item['text']); ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- CENTER ICONS -->
                <div class="col-md-4 center-col">
                    <div class="benefits-center">
                        <?php if(!empty($benefits['center_icons'])): ?>
                            <?php 
                                $center = $benefits['center_icons']; 
                            ?>
                            <?php if(!empty($center['top_left_icon'])): ?>
                                <div class="benefit-box-icon benefit-box-top-left">
                                    <img src="<?php echo esc_url($center['top_left_icon']['url']); ?>" alt="<?php echo esc_attr($center['top_left_icon']['alt']); ?>">
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($center['top_right_icon'])): ?>
                                <div class="benefit-box-icon benefit-box-top-right">
                                    <img src="<?php echo esc_url($center['top_right_icon']['url']); ?>" alt="<?php echo esc_attr($center['top_right_icon']['alt']); ?>">
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($center['bottom_left_icon'])): ?>
                                <div class="benefit-box-icon benefit-box-bottom-left">
                                    <img src="<?php echo esc_url($center['bottom_left_icon']['url']); ?>" alt="<?php echo esc_attr($center['bottom_left_icon']['alt']); ?>">
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($center['bottom_right_icon'])): ?>
                                <div class="benefit-box-icon benefit-box-bottom-right">
                                    <img src="<?php echo esc_url($center['bottom_right_icon']['url']); ?>" alt="<?php echo esc_attr($center['bottom_right_icon']['alt']); ?>">
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($center['center_icon'])): ?>
                                <div class="benefits-center-icon">
                                    <img src="<?php echo esc_url($center['center_icon']['url']); ?>" alt="<?php echo esc_attr($center['center_icon']['alt']); ?>">
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- RIGHT SIDE BENEFITS -->
                <div class="col-md-4">
                    <?php if(!empty($benefits['right_side_benefits'])): ?>
                        <?php foreach($benefits['right_side_benefits'] as $item): ?>
                            <div class="benefit-box">
                                <div class="benefit-box-title">
                                    <?php echo esc_html($item['title']); ?>
                                </div>
                                <div class="benefit-box-text">
                                    <?php echo esc_html($item['text']); ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
</section>
<?php endif; ?>




<!-- Section 4: What Makes Our Solutions Different -->
<section id="solutions" class="section-white solutionwrap">
    <div class="container">
        <h2 class="section-title">
            <?php echo get_field('solutions_section')['solutions_title']; ?>
        </h2>

        <div class="row">
            <?php 
            $solutions_group = get_field('solutions_section');
            if ($solutions_group && !empty($solutions_group['solutions'])): 
                foreach ($solutions_group['solutions'] as $item): 
            ?>
                <div class="col-md-6">
                    <div class="solution-box">
                        <h4><?php echo esc_html($item['title']); ?></h4>
                        <p><?php echo esc_html($item['description']); ?></p>
                    </div>
                </div>
            <?php endforeach; endif; ?>
        </div>
    </div>
</section>
<!-- Section 4 -->


<!-- Section 5: FAQ -->
<section id="faq" class="section-white">
    <div class="container">

        <h2 class="section-title mb-3">Frequently Asked Questions</h2>

        <div class="row justify-content-center">
            <div class="col-lg-10">

                <?php if (have_rows('faq_items')): ?>
                    <?php $i = 0;
                    while (have_rows('faq_items')): the_row();
                        $question = get_sub_field('faq_question');
                        $answer = get_sub_field('faq_answer');
                        $active = ($i === 0) ? 'active' : '';
                        $icon = ($i === 0) ? 'fa-chevron-up' : 'fa-chevron-down';
                    ?>

                        <div class="faq-item <?php echo $active; ?>">
                            <div class="faq-question" onclick="toggleFAQ(this)">
                                <span><?php echo $question; ?></span>
                                <button class="faq-toggle-btn" type="button">
                                    <i class="fa <?php echo $icon; ?> faq-icon"></i>
                                </button>
                            </div>
                            <div class="faq-answer <?php echo $active; ?>">
                                <p><?php echo $answer; ?></p>
                            </div>
                        </div>

                    <?php $i++;
                    endwhile; ?>
                <?php endif; ?>

            </div>
        </div>

    </div>
</section>




<!-- Section 6: Ending CTA -->
<?php
$ctas = get_field('cta');
if ($ctas): ?>
    <section class="cta-section">
        <div class="container">

            <div class="cta-box">
                <h2><?php echo $ctas['cta_title']; ?></h2>

                <p><?php echo $ctas['cta_description_1']; ?></p>
                <p><?php echo $ctas['cta_description_2']; ?></p>
                <a href="<?php echo $ctas['cta_url']; ?>" class="btn btn-light btn-lg">Talk with our experts</a>

            </div>
    </section>

<?php endif; ?>
 <script>
        // FAQ Toggle Function
        function toggleFAQ(element) {
            const faqItem = element.closest('.faq-item');
            const faqAnswer = faqItem.querySelector('.faq-answer');
            const faqIcon = faqItem.querySelector('.faq-icon');
            const isActive = faqItem.classList.contains('active');
            
            // Close all FAQ items
            document.querySelectorAll('.faq-item').forEach(item => {
                item.classList.remove('active');
                item.querySelector('.faq-answer').classList.remove('active');
                const icon = item.querySelector('.faq-icon');
                if (icon) {
                    icon.classList.remove('fa-chevron-up');
                    icon.classList.add('fa-chevron-down');
                }
            });
            
            // Open clicked item if it wasn't active
            if (!isActive) {
                faqItem.classList.add('active');
                faqAnswer.classList.add('active');
                if (faqIcon) {
                    faqIcon.classList.remove('fa-chevron-down');
                    faqIcon.classList.add('fa-chevron-up');
                }
            }
        }
        
        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
        
        // Form submission handler
        document.getElementById('contactForm').addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Thank you for your interest! We will contact you soon.');
            this.reset();
        });
    </script>



<?php get_footer();


