<?php

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_action( 'widgets_init', 'wpls_pro_logo_slider_widget' );

/**
 * Register logo showcase slider widget
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
function wpls_pro_logo_slider_widget() {
	register_widget( 'Wpls_Pro_Logo_Slider' );
}

/**
 * Wpls_Pro_Logo_Slider Widget Class.
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
class Wpls_Pro_Logo_Slider extends WP_Widget {

	/**
	 * Widget setup.
	 */

	var $defaults;

	function __construct() {

		// Widget settings
		$widget_ops = array( 'classname' => 'wpls-pro-logo-slider', 'description' => __( 'Display logos in a slider in a sidebar.', 'logoshowcase' ) );

		// Create the widget
		parent::__construct( 'wpls-pro-logo-slider', __( 'Logo Showcase - Slider View', 'logoshowcase' ), $widget_ops );

		$this->defaults = array(
				'title' 			=> __( 'Logo Showcase Slider', 'logoshowcase' ),
				'limit' 			=> 5,
				'cat_id' 			=> '',
				'include_cat_child'	=> 1,
				'order'             => 'desc',
				'orderby'           => 'date',
				'link_target' 		=> '',
				'show_title' 		=> 0,
				'tooltip'			=> 0,
				'image_size' 		=> 'original',
				'design'			=> 'design-1',
				'animation'			=> '',
				'words_limit'		=> 55,
				'content_tail'		=> '...',
				'posts'             => '',
				'exclude_posts'     => '',
				'exclude_cat'		=> array(),
				'slides_column' 	=> '1',
				'slides_scroll' 	=> '1',
				'dots' 				=> 'true',
				'arrows' 			=> 'true',
				'autoplay' 			=> 'true',
				'autoplay_interval' => '3000',
				'speed' 			=> '600',
				'center_mode' 		=> 'false',
				'loop' 				=> 'true',
				'ticker'			=> 0,
				'query_offset'      => '',
			);	
	}

	/**
	 * Updates the widget control options
	 *
	 * @package WP Logo Showcase Responsive Slider Pro
	 * @since 1.0.0
	 */
	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		// Set the instance to the new instance
		$instance = $new_instance;

		// Input fields
		$instance['title']				= sanitize_text_field( $new_instance['title'] );
		$instance['design'] 			= !empty($new_instance['design'])		? $new_instance['design'] 		: 'wpls-design-1';
		$instance['image_size'] 		= !empty($new_instance['image_size']) 	? $new_instance['image_size'] 	: 'original';
		$instance['cat_id'] 			= $new_instance['cat_id'];
		$instance['include_cat_child'] 	= isset($new_instance['include_cat_child']) ? 1 						: 0;
		$instance['limit'] 				= (empty($new_instance['limit']) || ($new_instance['limit'] < -1) ) ? 5 : $new_instance['limit'];
		$instance['order']              = ($new_instance['order'] == 'asc') 	? 'asc' 						: 'desc';
		$instance['orderby']            = $new_instance['orderby'];
		$instance['link_target'] 		= $new_instance['link_target'];
		$instance['animation'] 			= $new_instance['animation'];
		$instance['show_title'] 		= isset($new_instance['show_title']) 	? 1 							: 0;
		$instance['tooltip'] 			= isset($new_instance['tooltip'])		? 1 							: 0;
		$instance['words_limit'] 		= !empty($new_instance['words_limit']) 	? $new_instance['words_limit'] 	: 55;
		$instance['content_tail']		= $new_instance['content_tail'];
		$instance['posts']              = $new_instance['posts'];
		$instance['exclude_posts']      = $new_instance['exclude_posts'];
		$instance['exclude_cat']      	= !empty($new_instance['exclude_cat']) 	? $new_instance['exclude_cat'] 	: '';
		$instance['slides_column'] 		= ($new_instance['slides_column'] > 0) 	? $new_instance['slides_column']: '1';
		$instance['slides_scroll'] 		= ($new_instance['slides_scroll'] > 0) 	? $new_instance['slides_scroll']: '1';
		$instance['ticker'] 			= isset($new_instance['ticker'])		? 1 							: 0;
		$instance['dots'] 				= $new_instance['dots'];
		$instance['arrows'] 			= $new_instance['arrows'];
		$instance['autoplay'] 			= $new_instance['autoplay'];
		$instance['center_mode'] 		= $new_instance['center_mode'];
		$instance['autoplay_interval']	= $new_instance['autoplay_interval'];
		$instance['loop']				= $new_instance['loop'];
		$instance['speed']				= $new_instance['speed'];
		$instance['query_offset']       = !empty($new_instance['query_offset']) ? $new_instance['query_offset'] : '';
		return $instance;
	}

	/**
	 * Displays the widget form in widget area
	 *
	 * @package WP Logo Showcase Responsive Slider Pro
	 * @since 1.0.0
	 */
	function form( $instance ) {
		$instance           = wp_parse_args( (array) $instance, $this->defaults );
		$designs_arr 		= wpls_pro_logo_designs();
		$wpls_animations 	= wpls_pro_animations();
		$cat_id 			= !empty($instance['cat_id']) 		? $instance['cat_id'] 		: array();
		$exclude_cat 		= !empty($instance['exclude_cat']) 	? $instance['exclude_cat'] 	: array();

		// Getting Categories
		$cat_args = array(
						'taxonomy' 	=> WPLS_PRO_CAT,
						'fields'	=> 'id=>name',
					);
		$wpls_cats = get_categories( $cat_args ); ?>

		<!-- Title Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'logoshowcase'); ?>:</label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
		</p>

		<!-- Design Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'design' ); ?>"><?php _e( 'Design', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'design' ); ?>" name="<?php echo $this->get_field_name( 'design' ); ?>">
				<?php if( !empty($designs_arr) ) {
						foreach ($designs_arr as $design_key => $design_data) {
							$design_val = isset($design_data['file']) ? $design_data['file'] : '';
							$design_name = isset($design_data['name']) ? $design_data['name'] : __('Design', 'logoshowcase'); ?>
							<option value="<?php echo $design_key; ?>" <?php selected( $instance['design'], $design_key ); ?> ><?php echo $design_name; ?></option>
				<?php } } ?>
			</select>
		</p>

		<!-- Image Size Field -->
		<p>
			<label for="<?php echo $this->get_field_id('image_size'); ?>"><?php _e( 'Image Size', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('image_size'); ?>" name="<?php echo $this->get_field_name('image_size'); ?>" type="text" value="<?php echo esc_attr($instance['image_size']); ?>" />
			<em><?php _e( 'Choose WordPress registered image size. e.g thumbnail, medium, large, full.', 'logoshowcase' ); ?></em>
		</p>

		<!-- Link Target Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'link_target' ); ?>"><?php _e( 'Link Target', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'link_target' ); ?>" name="<?php echo $this->get_field_name( 'link_target' ); ?>">
				<option value=""><?php _e('Open in Same Window', 'logoshowcase') ?></option>
				<option value="blank" <?php selected( $instance['link_target'], 'blank' ); ?> ><?php _e('Open in New Window', 'logoshowcase') ?></option>
			</select>
		</p>

		<!-- Animation Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'animation' ); ?>"><?php _e( 'Animation Effect', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'animation' ); ?>" name="<?php echo $this->get_field_name( 'animation' ); ?>">
				<option value=""><?php _e('Select Animation Effect', 'logoshowcase'); ?></option>	
				<?php if( !empty($wpls_animations) ) {
					foreach ($wpls_animations as $anim_key => $anim_name) { ?>
						<option value="<?php echo $anim_key; ?>" <?php selected( $instance['animation'], $anim_key ); ?> ><?php echo $anim_name; ?></option>
				<?php } } ?>
			</select>
		</p>

		<!-- Category Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'cat_id' ); ?>"><?php _e( 'Category', 'logoshowcase'); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'cat_id[]' ) ?>" id="<?php echo $this->get_field_id( 'cat_id' ); ?>" class="widefat" multiple="multiple">
				<?php if( !is_wp_error($wpls_cats) && !empty($wpls_cats) ) {
					foreach ($wpls_cats as $category_id => $cat_name) { ?>
					<option value="<?php echo $category_id; ?>" <?php selected( in_array($category_id, $cat_id), 1 ); ?>><?php echo $cat_name; ?></option>
				<?php } } ?>
			</select>
		</p>

		<!-- Exclude Category Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'exclude_cat' ); ?>"><?php _e( 'Exclude Category', 'logoshowcase'); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'exclude_cat[]' ) ?>" id="<?php echo $this->get_field_id( 'exclude_cat' ); ?>" class="widefat" multiple="multiple">
				<?php if( !is_wp_error($wpls_cats) && !empty($wpls_cats) ) {
					foreach ($wpls_cats as $category_id => $cat_name) { ?>
					<option value="<?php echo $category_id; ?>" <?php selected( in_array($category_id, $exclude_cat), 1 ); ?>><?php echo $cat_name; ?></option>
				<?php } } ?>
			</select>
			<em><?php _e('Exclude category logos.', 'logoshowcase'); ?></em>
		</p>

		<!-- Include Category Child -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'include_cat_child' ); ?>" name="<?php echo $this->get_field_name( 'include_cat_child' ); ?>" <?php checked( $instance['include_cat_child'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'include_cat_child' ); ?>"><?php _e( 'Include Category Child', 'logoshowcase'); ?></label><br/>
			<em><?php _e('Check this box if you want to display child category post if parent category is selected.', 'logoshowcase'); ?></em>
		</p>

		<!-- Show Title Field -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'show_title' ); ?>" name="<?php echo $this->get_field_name( 'show_title' ); ?>" <?php checked( $instance['show_title'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'show_title' ); ?>"><?php _e( 'Show Title', 'logoshowcase'); ?></label>
		</p>

		<!-- Show Tooltip -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'tooltip' ); ?>" name="<?php echo $this->get_field_name( 'tooltip' ); ?>" <?php checked( $instance['tooltip'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'tooltip' ); ?>"><?php _e( 'Show Tooltip', 'logoshowcase'); ?></label>
		</p>

		<!-- Display Specific Posts -->
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Display Specific Post', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" type="text" value="<?php echo esc_attr($instance['posts']); ?>" />
			<em><?php _e('Enter Post id which you want to display. You can enter multiple ids with comma seperated.', 'logoshowcase'); ?></em>
		</p>

		<!-- Exclude Posts -->
		<p>
			<label for="<?php echo $this->get_field_id('exclude_posts'); ?>"><?php _e( 'Exclude Posts', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('exclude_posts'); ?>" name="<?php echo $this->get_field_name('exclude_posts'); ?>" type="text" value="<?php echo esc_attr($instance['exclude_posts']); ?>" />
			<em><?php _e('Enter Post id which you do not want to display. You can enter multiple ids with comma seperated.', 'logoshowcase'); ?></em>
		</p>

		<!-- Number of Items Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Number of Items', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="-1" id="<?php echo $this->get_field_id( 'limit' ); ?>" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" value="<?php echo $instance['limit']; ?>" />
		</p>

		<!-- Order By -->
		<p>
			<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e( 'Order By', 'logoshowcase' ); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'orderby' ); ?>" class="widefat" id="<?php echo $this->get_field_id( 'orderby' ); ?>">
				<option value="date" <?php selected( $instance['orderby'], 'date' ); ?>><?php _e( 'Post Date', 'logoshowcase' ); ?></option>
				<option value="modified" <?php selected( $instance['orderby'], 'modified' ); ?>><?php _e( 'Post Updated Date', 'logoshowcase' ); ?></option>
				<option value="ID" <?php selected( $instance['orderby'], 'ID' ); ?>><?php _e( 'Post Id', 'logoshowcase' ); ?></option>
				<option value="title" <?php selected( $instance['orderby'], 'title' ); ?>><?php _e( 'Post Title', 'logoshowcase' ); ?></option>
				<option value="rand" <?php selected( $instance['orderby'], 'rand' ); ?>><?php _e( 'Random', 'logoshowcase' ); ?></option>
				<option value="menu_order" <?php selected( $instance['orderby'], 'menu_order' ); ?>><?php _e( 'Menu Order (Sort Order)', 'logoshowcase' ); ?></option>
			</select>
		</p>

		<!-- Order -->
		<p>
			<label for="<?php echo $this->get_field_id( 'order' ); ?>"><?php _e( 'Order', 'logoshowcase' ); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'order' ); ?>" class="widefat" id="<?php echo $this->get_field_id( 'order' ); ?>">
				<option value="asc" <?php selected( $instance['order'], 'asc' ); ?>><?php _e( 'Ascending', 'logoshowcase' ); ?></option>
				<option value="desc" <?php selected( $instance['order'], 'desc' ); ?>><?php _e( 'Descending', 'logoshowcase' ); ?></option>
			</select>
		</p>

		<!-- Content Word Limit Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'words_limit' ); ?>"><?php _e( 'Content Words Limit', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="1" id="<?php echo $this->get_field_id( 'words_limit' ); ?>" name="<?php echo $this->get_field_name( 'words_limit' ); ?>" type="number" value="<?php echo $instance['words_limit']; ?>" />
			<em><?php _e('Note: This parameter will work with design 4 only.', 'logoshowcase'); ?></em>
		</p>

		<!-- Content Tail Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'content_tail' ); ?>"><?php _e( 'Content Tail', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="1" id="<?php echo $this->get_field_id( 'content_tail' ); ?>" name="<?php echo $this->get_field_name( 'content_tail' ); ?>" type="text" value="<?php echo $instance['content_tail']; ?>" />
			<em><?php _e('Note: This parameter will work with design 4 only.', 'logoshowcase'); ?></em>
		</p>

		<h3><?php _e('Logo Slider Setting', 'logoshowcase'); ?></h3>

		<!-- Slides Column Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'slides_column' ); ?>"><?php _e( 'Slides Column', 'logoshowcase'); ?>:</label>
			<input class="widefat" min="1" id="<?php echo $this->get_field_id( 'slides_column' ); ?>" name="<?php echo $this->get_field_name( 'slides_column' ); ?>" type="number" value="<?php echo $instance['slides_column']; ?>" />
			<em><?php _e('Number of slides column.', 'logoshowcase'); ?></em>
		</p>

		<!-- Slides Scroll Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'slides_scroll' ); ?>"><?php _e( 'Slides Scroll', 'logoshowcase'); ?>:</label>
			<input class="widefat" min="1" id="<?php echo $this->get_field_id( 'slides_scroll' ); ?>" name="<?php echo $this->get_field_name( 'slides_scroll' ); ?>" type="number" value="<?php echo $instance['slides_scroll']; ?>" />
			<em><?php _e('Number of slides to scroll at a time.', 'logoshowcase'); ?></em>
		</p>

		<!-- Dots Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'dots' ); ?>"><?php _e( 'Dots', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'dots' ); ?>" name="<?php echo $this->get_field_name( 'dots' ); ?>">
				<option value="true" <?php selected( $instance['dots'], 'true' ); ?>><?php _e('True', 'logoshowcase') ?></option>
				<option value="false" <?php selected( $instance['dots'], 'false' ); ?>><?php _e('False', 'logoshowcase') ?></option>
			</select>
			<em><?php _e('Enable slider pagination dots.', 'logoshowcase'); ?></em>
		</p>

		<!-- Arrows Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'arrows' ); ?>"><?php _e( 'Arrows', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'arrows' ); ?>" name="<?php echo $this->get_field_name( 'arrows' ); ?>">
				<option value="true" <?php selected( $instance['arrows'], 'true' ); ?>><?php _e('True', 'logoshowcase') ?></option>
				<option value="false" <?php selected( $instance['arrows'], 'false' ); ?>><?php _e('False', 'logoshowcase') ?></option>
			</select>
			<em><?php _e('Enable slider navigation arrow.', 'logoshowcase'); ?></em>
		</p>

		<!-- Autoplay Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'autoplay' ); ?>"><?php _e( 'Autoplay', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'autoplay' ); ?>" name="<?php echo $this->get_field_name( 'autoplay' ); ?>">
				<option value="true" <?php selected( $instance['autoplay'], 'true' ); ?>><?php _e('True', 'logoshowcase') ?></option>
				<option value="false" <?php selected( $instance['autoplay'], 'false' ); ?>><?php _e('False', 'logoshowcase') ?></option>
			</select>
			<em><?php _e('Enable slider autoplay.', 'logoshowcase'); ?></em>
		</p>

		<!-- Loop Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'loop' ); ?>"><?php _e( 'Loop', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'loop' ); ?>" name="<?php echo $this->get_field_name( 'loop' ); ?>">
				<option value="true" <?php selected( $instance['loop'], 'true' ); ?>><?php _e('True', 'logoshowcase') ?></option>
				<option value="false" <?php selected( $instance['loop'], 'false' ); ?>><?php _e('False', 'logoshowcase') ?></option>
			</select>
			<em><?php _e('Runs the slider contineously.', 'logoshowcase'); ?></em>
		</p>

		<!-- Center Mode Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'center_mode' ); ?>"><?php _e( 'Center Mode', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'center_mode' ); ?>" name="<?php echo $this->get_field_name( 'center_mode' ); ?>">
				<option value="true" <?php selected( $instance['center_mode'], 'true' ); ?>><?php _e('True', 'logoshowcase') ?></option>
				<option value="false" <?php selected( $instance['center_mode'], 'false' ); ?>><?php _e('False', 'logoshowcase') ?></option>
			</select>
			<em><?php _e('Enable center mode. Note: Works well with odd number of Slides Column and Slides Scroll is set to 1.', 'logoshowcase'); ?></em>
		</p>

		<!-- Autoplay Interval Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'autoplay_interval' ); ?>"><?php _e( 'Autoplay Interval', 'logoshowcase'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'autoplay_interval' ); ?>" name="<?php echo $this->get_field_name( 'autoplay_interval' ); ?>" type="text" value="<?php echo $instance['autoplay_interval']; ?>" />
			<em><?php _e('Slider slides interval time.', 'logoshowcase'); ?></em>
		</p>

		<!-- Speed Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'speed' ); ?>"><?php _e( 'Speed', 'logoshowcase'); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'speed' ); ?>" name="<?php echo $this->get_field_name( 'speed' ); ?>" type="text" value="<?php echo $instance['speed']; ?>" />
			<em><?php _e('Slider speed.', 'logoshowcase'); ?></em>
		</p>

		<!-- Show Tooltip -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'ticker' ); ?>" name="<?php echo $this->get_field_name( 'ticker' ); ?>" <?php checked( $instance['ticker'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'ticker' ); ?>"><?php _e( 'Enable Ticker Mode', 'logoshowcase'); ?></label><br/>
			<em><?php _e('Runs the slider contineously.', 'logoshowcase'); ?></em><br/>
			<em><?php _e('Note: When you enable ticker mode Autoplay, Slides Scroll and Autoplay Interval are set to default.', 'logoshowcase'); ?></em>
		</p>

		<!-- Query Offset -->
		<p>
			<label for="<?php echo $this->get_field_id('query_offset'); ?>"><?php esc_html_e( 'Query Offset', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('query_offset'); ?>" name="<?php echo $this->get_field_name('query_offset'); ?>" type="number" value="<?php echo $instance['query_offset']; ?>" min="0" />
			<em><?php _e('Query `offset` parameter to exclude number of post. Leave empty for default.', 'logoshowcase'); ?></em><br/>
			<em><?php _e('Note: This parameter will not work when Number of Items is set to -1.', 'logoshowcase'); ?></em>
		</p>
<?php
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @package WP Logo Showcase Responsive Slider Pro
	 * @since 1.0.0
	 */
	function widget( $args, $instance ) {

		$atts = wp_parse_args( (array) $instance, $this->defaults );
		extract($args, EXTR_SKIP);

		$title 							= apply_filters( 'widget_title', $atts['title'], $atts, $this->id_base );
		$atts['cat_name']				= $atts['title'];
		$atts['cat_id']					= $atts['cat_id'];
		$atts['include_cat_child'] 		= ($atts['include_cat_child'] == 1) ? true 					: false;
		$atts['limit']					= $atts['limit'];
		$atts['design'] 				= $atts['design'];
		$atts['link_target'] 			= ($atts['link_target'] == 'blank') ? '_blank' 				: '_self';
		$atts['image_size'] 			= $atts['image_size'];
		$atts['show_title'] 			= !empty($atts['show_title']) 		? 'true' 				: 'false';
		$atts['animation'] 				= !empty($atts['animation']) 		? $atts['animation'] 	: '';
		$atts['animation_cls'] 			= empty($animation) 				? 'has-no-animation' 	: '';
		$atts['tooltip'] 				= $atts['tooltip'];
		$atts['order'] 					= $atts['order'];
		$atts['orderby'] 				= $atts['orderby'];
		$atts['content_words_limit'] 	= $atts['words_limit'];
		$atts['content_tail'] 			= html_entity_decode($atts['content_tail']);
		$atts['posts'] 					= !empty($atts['posts']) 			? explode(',', trim($atts['posts'])) 			: array();
		$atts['exclude_posts'] 			= !empty($atts['exclude_posts']) 	? explode(',', trim($atts['exclude_posts'])) 	: array();
		$atts['exclude_cat'] 			= $atts['exclude_cat'];
		$atts['slides_column']			= $atts['slides_column'];
		$atts['slides_scroll']			= $atts['slides_scroll'];
		$atts['dots']					= $atts['dots'];
		$atts['arrows']					= $atts['arrows'];
		$atts['autoplay']				= $atts['autoplay'];
		$atts['speed']					= $atts['speed'];
		$atts['center_mode']			= $atts['center_mode'];
		$atts['loop']					= $atts['loop'];
		$atts['autoplay_interval']		= $atts['autoplay_interval'];
		$atts['ticker'] 				= ($atts['ticker'] == 1) ? 'true' 						: 'false';
		$atts['query_offset'] 			= isset($atts['query_offset']) 	? $atts['query_offset'] : '';

		// Extract Shortcode Var
		extract($atts);

		// Little tweak for ticker mode
		if( $ticker	== 'true' ) {
			$autoplay 			= 'true';
			$slides_scroll 		= 1;
			$autoplay_interval 	= 0;
		}

		// Enqueus required script
		wp_enqueue_script( 'wpos-slick-jquery' );
		if($tooltip) {
			wp_enqueue_script( 'wpos-tooltip-js' );
		}
		wp_enqueue_script( 'wpls-pro-public-js' );

		// Taking some globals
		global $post;

		// Taking some variables
		$atts['unique']	= wpls_pro_get_unique();

		// WP Query Parameters
		$query_args = array(
						'post_type' 			=> WPLS_PRO_POST_TYPE,
						'posts_per_page'		=> $limit,
						'post_status' 			=> array( 'publish' ),
						'order'          		=> $order,
						'orderby'        		=> $orderby,
						'post__in'				=> $posts,
						'post__not_in'			=> $exclude_posts,
						'offset'            	=> $query_offset,
						'ignore_sticky_posts'	=> true,
					);

		// If category is passed
		if( !empty($cat_id) ) {

			$query_args['tax_query'] = array( 
											array(
												'taxonomy' 			=> WPLS_PRO_CAT, 
												'field' 			=> 'term_id',
												'terms' 			=> $cat_id,
												'include_children'	=> $include_cat_child,
											));

		} else if( !empty($exclude_cat) ) {

			$query_args['tax_query'] = array(
											array(
												'taxonomy' 			=> WPLS_PRO_CAT,
												'field' 			=> 'term_id',
												'terms' 			=> $exclude_cat,
												'operator'			=> 'NOT IN',
												'include_children'	=> $include_cat_child,
											));
		}

		// WP Query
		$logo_query = new WP_Query($query_args);
		$post_count = $logo_query->post_count;

		// Slider configuration and taken care of centermode
		$slides_column 				= (!empty($slides_column) && $slides_column <= $post_count) ? $slides_column : $post_count;
		$center_mode				= ($center_mode == 'true' && $slides_column % 2 != 0 && $slides_column != $post_count) ? 'true' : 'false';
		$atts['center_mode_cls']	= ($center_mode == "true") ? 'wpls-center-mode' : '';

		// Slider variable
		$atts['logo_conf'] 	= compact('slides_column', 'slides_scroll', 'dots', 'arrows', 'autoplay', 'autoplay_interval', 'speed', 'center_mode', 'loop', 'ticker');

		// Start Widget Output
		echo $before_widget;

		if ( $title ) {
			echo $before_title . $title . $after_title;
		}

		// If Posts is there
		if( $logo_query->have_posts() ) {

			wpls_get_template( 'widgets/slider/loop-start.php', $atts ); // loop start

			while ($logo_query->have_posts()) : $logo_query->the_post();

					$atts['feat_image'] 	= wpls_pro_get_logo_image($post->ID, $image_size);
					$atts['logourl'] 		= get_post_meta( $post->ID, 'wplss_slide_link', true );
					$atts['logo_title'] 	= get_the_title();
					$atts['cnt_wrp_cls'] 	= (!empty($atts['logo_title']) && $tooltip) ? 'wpls-tooltip' : '';
					$atts['title_attr']	 	= ($tooltip) ? 'title="'.$atts['logo_title'].'"' : '';

					wpls_get_template( "widgets/slider/{$design}.php", $atts, null, null, "designs/{$design}.php" ); // loop designs

			endwhile;

			wpls_get_template( 'widgets/slider/loop-end.php', $atts ); // loop end

		} // End of have_post()

		wp_reset_postdata(); // Reset WP Query

		echo $after_widget;
	}
}