<?php

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_action( 'widgets_init', 'wpls_pro_logo_grid_list_widget' );

/**
 * Register logo showcase grid widget
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
function wpls_pro_logo_grid_list_widget() {
	register_widget( 'Wpls_Pro_Logo_Grid_Lists' );
}

/**
 * Wpls_Pro_Logo_Grid_Lists Widget Class.
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
class Wpls_Pro_Logo_Grid_Lists extends WP_Widget {

	/**
	 * Widget setup.
	 */
	
	var $defaults;

	function __construct() {

		// Widget settings
		$widget_ops = array( 'classname' => 'wpls-pro-logo-grid-lists', 'description' => __( 'Display logos in a sidebar in grid view.', 'logoshowcase' ) );

		// Create the widget
		parent::__construct( 'wpls-pro-logo-grid-lists', __( 'Logo Showcase - Grid View', 'logoshowcase' ), $widget_ops );

		// Widgets defaults
		$this->defaults = array(
				'title' 			=> __( 'Logo Showcase', 'logoshowcase' ),
				'limit' 			=> 5,
				'grid' 				=> 1,
				'cat_id' 			=> '',
				'include_cat_child' => 1,
				'order'             => 'desc',
				'orderby'           => 'date',
				'link_target' 		=> '',
				'posts'             => '',
				'exclude_posts'     => '',
				'show_title' 		=> 0,
				'image_size' 		=> 'original',
				'design'			=> 'design-1',
				'tooltip'			=> 0,
				'animation'			=> '',
				'words_limit'		=> 55,
				'content_tail'		=> '...',
				'exclude_cat'		=> array(),
				'query_offset'      => '',
			);
	}

	/**
	 * Updates the widget control options
	 *
	 * @package WP Logo Showcase Responsive Slider Pro
	 * @since 1.0.0
	 */
	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		// Input fields
		$instance['title']				= sanitize_text_field( $new_instance['title'] );
		$instance['design'] 			= $new_instance['design'];
		$instance['image_size'] 		= $new_instance['image_size'];
		$instance['cat_id'] 			= $new_instance['cat_id'];
		$instance['include_cat_child'] 	= isset($new_instance['include_cat_child']) ? 1 							: 0;
		$instance['limit'] 				= (empty($new_instance['limit']) || ($new_instance['limit'] < -1) ) ? 5 	: $new_instance['limit'];
		$instance['order']              = ($new_instance['order'] == 'asc') 		? 'asc' 						: 'desc';
		$instance['orderby']            = $new_instance['orderby'];
		$instance['grid'] 				= (empty($new_instance['grid']) || $new_instance['grid'] > 12 ) 	? 2 	: $new_instance['grid'];
		$instance['link_target'] 		= $new_instance['link_target'];
		$instance['posts']              = $new_instance['posts'];
		$instance['exclude_posts']      = $new_instance['exclude_posts'];
		$instance['exclude_cat']      	= $new_instance['exclude_cat'];
		$instance['show_title'] 		= isset($new_instance['show_title']) 		? 1 							: 0;
		$instance['tooltip'] 			= isset($new_instance['tooltip']) 			? 1 							: 0;
		$instance['animation'] 			= $new_instance['animation'];
		$instance['words_limit'] 		= $new_instance['words_limit'];
		$instance['content_tail']		= $new_instance['content_tail'];
		$instance['query_offset']       = !empty($new_instance['query_offset']) ? $new_instance['query_offset'] : '';

		return $instance;
	}

	/**
	 * Displays the widget form in widget area
	 *
	 * @package WP Logo Showcase Responsive Slider Pro
	 * @since 1.0.0
	 */
	function form( $instance ) {
		$instance           = wp_parse_args( (array) $instance, $this->defaults );
		$designs_arr 		= wpls_pro_logo_designs();
		$wpls_animations 	= wpls_pro_animations();
		$cat_id 			= !empty($instance['cat_id']) 		? $instance['cat_id'] 		: array();
		$exclude_cat 		= !empty($instance['exclude_cat']) 	? $instance['exclude_cat'] 	: array();

		// Getting Categories
		$cat_args = array(
						'taxonomy' 	=> WPLS_PRO_CAT,
						'fields'	=> 'id=>name',
					);
		$wpls_cats = get_categories( $cat_args ); ?>

		<!-- Title Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'logoshowcase'); ?>:</label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
		</p>

		<!-- Design Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'design' ); ?>"><?php _e( 'Design', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'design' ); ?>" name="<?php echo $this->get_field_name( 'design' ); ?>">
				<?php if( !empty($designs_arr) ) {
						foreach ($designs_arr as $design_key => $design_data) {
							$design_val = isset($design_data['file']) ? $design_data['file'] : '';
							$design_name = isset($design_data['name']) ? $design_data['name'] : __('Design', 'logoshowcase');
				?>
							<option value="<?php echo $design_key; ?>" <?php selected( $instance['design'], $design_key ); ?> ><?php echo $design_name; ?></option>	
				<?php	}
					}
				?>
			</select>
		</p>

		<!-- Animation Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'animation' ); ?>"><?php _e( 'Animation Effect', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'animation' ); ?>" name="<?php echo $this->get_field_name( 'animation' ); ?>">
				<option value=""><?php _e('Select Animation Effect', 'logoshowcase'); ?></option>	
				<?php if( !empty($wpls_animations) ) {
						foreach ($wpls_animations as $anim_key => $anim_name) {
				?>
							<option value="<?php echo $anim_key; ?>" <?php selected( $instance['animation'], $anim_key ); ?> ><?php echo $anim_name; ?></option>
				<?php	}
					}
				?>
			</select>
		</p>

		<!-- Logo Columns Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'grid' ); ?>"><?php _e( 'Logo Columns', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="1" max="12" id="<?php echo $this->get_field_id( 'grid' ); ?>" name="<?php echo $this->get_field_name( 'grid' ); ?>" type="number" value="<?php echo $instance['grid']; ?>" />
		</p>

		<!-- Category Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'cat_id' ); ?>"><?php _e( 'Category', 'logoshowcase'); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'cat_id[]' ) ?>" id="<?php echo $this->get_field_id( 'cat_id' ); ?>" class="widefat" multiple="multiple">
				<?php if( !is_wp_error($wpls_cats) && !empty($wpls_cats) ) {
						foreach ($wpls_cats as $category_id => $cat_name) { ?>
							<option value="<?php echo $category_id; ?>" <?php selected( in_array($category_id, $cat_id), 1 ); ?>><?php echo $cat_name; ?></option>
				<?php } } ?>
			</select>
		</p>

		<!-- Exclude Category Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'exclude_cat' ); ?>"><?php _e( 'Exclude Category', 'logoshowcase'); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'exclude_cat[]' ) ?>" id="<?php echo $this->get_field_id( 'exclude_cat' ); ?>" class="widefat" multiple="multiple">
				<?php if( !is_wp_error($wpls_cats) && !empty($wpls_cats) ) {
						foreach ($wpls_cats as $category_id => $cat_name) { ?>
							<option value="<?php echo $category_id; ?>" <?php selected( in_array($category_id, $exclude_cat), 1 ); ?>><?php echo $cat_name; ?></option>
				<?php } } ?>
			</select>
			<em><?php _e('Exclude category logos.', 'logoshowcase'); ?></em>
		</p>

		<!-- Display Specific Posts -->
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Display Specific Post', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" type="text" value="<?php echo esc_attr($instance['posts']); ?>" />
			<em><?php _e('Enter Post id which you want to display. You can enter multiple ids with comma seperated.', 'logoshowcase'); ?></em>
		</p>

		<!-- Exclude Posts -->
		<p>
			<label for="<?php echo $this->get_field_id('exclude_posts'); ?>"><?php _e( 'Exclude Posts', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('exclude_posts'); ?>" name="<?php echo $this->get_field_name('exclude_posts'); ?>" type="text" value="<?php echo esc_attr($instance['exclude_posts']); ?>" />
			<em><?php _e('Enter Post id which you do not want to display. You can enter multiple ids with comma seperated.', 'logoshowcase'); ?></em>
		</p>

		<!-- Include Category Child -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'include_cat_child' ); ?>" name="<?php echo $this->get_field_name( 'include_cat_child' ); ?>" <?php checked( $instance['include_cat_child'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'include_cat_child' ); ?>"><?php _e( 'Include Category Child', 'logoshowcase'); ?></label><br/>
			<em><?php _e('Check this box if you want to display child category post if parent category is selected.', 'logoshowcase'); ?></em>
		</p>

		<!-- Show Title Field -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'show_title' ); ?>" name="<?php echo $this->get_field_name( 'show_title' ); ?>" <?php checked( $instance['show_title'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'show_title' ); ?>"><?php _e( 'Show Title', 'logoshowcase'); ?></label>
		</p>

		<!-- Show Tooltip -->
		<p>
			<input type="checkbox" value="1" id="<?php echo $this->get_field_id( 'tooltip' ); ?>" name="<?php echo $this->get_field_name( 'tooltip' ); ?>" <?php checked( $instance['tooltip'], 1 ); ?>>
			<label for="<?php echo $this->get_field_id( 'tooltip' ); ?>"><?php _e( 'Show Tooltip', 'logoshowcase'); ?></label>
		</p>

		<!-- Number of Items Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Number of Items', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="-1" id="<?php echo $this->get_field_id( 'limit' ); ?>" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" value="<?php echo $instance['limit']; ?>" />
		</p>	

		<!-- Image Size Field -->
		<p>
			<label for="<?php echo $this->get_field_id('image_size'); ?>"><?php _e( 'Image Size', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('image_size'); ?>" name="<?php echo $this->get_field_name('image_size'); ?>" type="text" value="<?php echo esc_attr($instance['image_size']); ?>" />
			<em><?php _e( 'Choose WordPress registered image size. e.g thumbnail, medium, large, full.', 'logoshowcase' ); ?></em>
		</p>

		<!-- Link Target Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'link_target' ); ?>"><?php _e( 'Link Target', 'logoshowcase'); ?>:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'link_target' ); ?>" name="<?php echo $this->get_field_name( 'link_target' ); ?>">
				<option value=""><?php _e('Open in Same Window', 'logoshowcase') ?></option>
				<option value="blank" <?php selected( $instance['link_target'], 'blank' ); ?> ><?php _e('Open in New Window', 'logoshowcase') ?></option>
			</select>
		</p>

		<!-- Order By -->
		<p>
			<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e( 'Order By', 'logoshowcase' ); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'orderby' ); ?>" class="widefat" id="<?php echo $this->get_field_id( 'orderby' ); ?>">
				<option value="date" <?php selected( $instance['orderby'], 'date' ); ?>><?php _e( 'Post Date', 'logoshowcase' ); ?></option>
				<option value="modified" <?php selected( $instance['orderby'], 'modified' ); ?>><?php _e( 'Post Updated Date', 'logoshowcase' ); ?></option>
				<option value="ID" <?php selected( $instance['orderby'], 'ID' ); ?>><?php _e( 'Post Id', 'logoshowcase' ); ?></option>
				<option value="title" <?php selected( $instance['orderby'], 'title' ); ?>><?php _e( 'Post Title', 'logoshowcase' ); ?></option>
				<option value="rand" <?php selected( $instance['orderby'], 'rand' ); ?>><?php _e( 'Random', 'logoshowcase' ); ?></option>
				<option value="menu_order" <?php selected( $instance['orderby'], 'menu_order' ); ?>><?php _e( 'Menu Order (Sort Order)', 'logoshowcase' ); ?></option>
			</select>
		</p>

		<!-- Order -->
		<p>
			<label for="<?php echo $this->get_field_id( 'order' ); ?>"><?php _e( 'Order', 'logoshowcase' ); ?>:</label>
			<select name="<?php echo $this->get_field_name( 'order' ); ?>" class="widefat" id="<?php echo $this->get_field_id( 'order' ); ?>">
				<option value="asc" <?php selected( $instance['order'], 'asc' ); ?>><?php _e( 'Ascending', 'logoshowcase' ); ?></option>
				<option value="desc" <?php selected( $instance['order'], 'desc' ); ?>><?php _e( 'Descending', 'logoshowcase' ); ?></option>
			</select>
		</p>

		<!-- Content Word Limit Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'words_limit' ); ?>"><?php _e( 'Content Words Limit', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="1" id="<?php echo $this->get_field_id( 'words_limit' ); ?>" name="<?php echo $this->get_field_name( 'words_limit' ); ?>" type="number" value="<?php echo $instance['words_limit']; ?>" />
			<em><?php _e('Note: This parameter will work with design 4 only.', 'logoshowcase'); ?></em>
		</p>

		<!-- Content Tail Field -->
		<p>
			<label for="<?php echo $this->get_field_id( 'content_tail' ); ?>"><?php _e( 'Content Tail', 'logoshowcase'); ?>:</label> 
			<input class="widefat" min="1" id="<?php echo $this->get_field_id( 'content_tail' ); ?>" name="<?php echo $this->get_field_name( 'content_tail' ); ?>" type="text" value="<?php echo $instance['content_tail']; ?>" />
			<em><?php _e('Note: This parameter will work with design 4 only.', 'logoshowcase'); ?></em>
		</p>

		<!-- Query Offset -->
		<p>
			<label for="<?php echo $this->get_field_id('query_offset'); ?>"><?php esc_html_e( 'Query Offset', 'logoshowcase' ); ?>:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('query_offset'); ?>" name="<?php echo $this->get_field_name('query_offset'); ?>" type="number" value="<?php echo $instance['query_offset']; ?>" min="0" />
			<em><?php _e('Query `offset` parameter to exclude number of post. Leave empty for default.', 'logoshowcase'); ?></em><br/>
			<em><?php _e('Note: This parameter will not work when Number of Items is set to -1.', 'logoshowcase'); ?></em>
		</p>

	<?php
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @package WP Logo Showcase Responsive Slider Pro
	 * @since 1.0.0
	 */
	function widget( $args, $instance ) {
		$atts = wp_parse_args( (array) $instance, $this->defaults );
		extract($args, EXTR_SKIP);
		
		$title          				= apply_filters( 'widget_title', $atts['title'], $atts, $this->id_base );
		$atts['cat_name']				= $atts['title'];
		$atts['cat_id']					= $atts['cat_id'];
		$atts['limit']					= $atts['limit'];
		$atts['order']              	= $atts['order'];
		$atts['orderby']            	= $atts['orderby'];
		$atts['grid']					= $atts['grid'];
		$atts['design'] 				= $atts['design'];
		$atts['image_size'] 			= $atts['image_size'];
		$atts['tooltip'] 				= $atts['tooltip'];
		$atts['animation'] 				= $atts['animation'];
		$atts['content_words_limit'] 	= $atts['words_limit'];
		$atts['exclude_cat'] 			= $atts['exclude_cat'];
		$atts['posts']              	= !empty($atts['posts']) 			? explode(',', trim($atts['posts'])) 			: array();
		$atts['exclude_posts']      	= !empty($atts['exclude_posts']) 	? explode(',', trim($atts['exclude_posts'])) 	: array();
		$atts['include_cat_child'] 		= ($atts['include_cat_child'] == 1) ? true 								: false;
		$atts['link_target'] 			= ($atts['link_target'] == 'blank') ? '_blank' 							: '_self';		
		$atts['show_title'] 			= !empty( $atts['show_title'] == 0) ? 'false' 							: 'true';
		$atts['grid_class']				= ($atts['grid'] <= 12 ) 			? ('wpls-col-'.($atts['grid'])) 	: 'wpls-col-4';
		$atts['animation_cls'] 			= ($atts['animation'] == '') 		? 'has-no-animation' 				: '';
		$atts['content_tail'] 			= html_entity_decode($atts['content_tail']);
		$atts['query_offset']       	= isset($atts['query_offset']) 		? $atts['query_offset'] 			: '';

		// Extract Shortcode Var
		extract($atts);

		// Enqueus required script
		if($tooltip == 1) {
			wp_enqueue_script( 'wpos-tooltip-js' );
		}
		wp_enqueue_script( 'wpls-pro-public-js' );

		// Taking some globals
		global $post;

		// Taking some variables
		$count = 1;

		// WP Query Parameters
		$query_args = array(
							'post_type' 			=> WPLS_PRO_POST_TYPE,
							'posts_per_page'		=> $limit,
							'post_status' 			=> array( 'publish' ),
							'order'          		=> $order,
							'orderby'        		=> $orderby,
							'post__in'				=> $posts,
							'post__not_in'			=> $exclude_posts,
							'offset'            	=> $query_offset,
							'ignore_sticky_posts'	=> true,
						);

		// If category is passed
		if( !empty($cat_id) ) {

			$query_args['tax_query'] = array( 
											array(
												'taxonomy' 			=> WPLS_PRO_CAT, 
												'field' 			=> 'term_id',
												'terms' 			=> $cat_id,
												'include_children'	=> $include_cat_child,
											));

		} else if( !empty($exclude_cat) ) {

			$query_args['tax_query'] = array(
											array(
												'taxonomy' 			=> WPLS_PRO_CAT,
												'field' 			=> 'term_id',
												'terms' 			=> $exclude_cat,
												'operator'			=> 'NOT IN',
												'include_children'	=> $include_cat_child,
											));
		}

		// WP Query
		$logo_query = new WP_Query($query_args);

		// Start Widget Output
		echo $before_widget;

		if ( $title ) {
			echo $before_title . $title . $after_title;
		}

		if( $logo_query->have_posts() ) {

			wpls_get_template( 'widgets/grid/loop-start.php', $atts ); // loop start

			while ($logo_query->have_posts()) : $logo_query->the_post();

				$first_last_cls 		= '';
				$atts['feat_image'] 	= wpls_pro_get_logo_image($post->ID, $image_size);
				$atts['logourl'] 		= get_post_meta( $post->ID, 'wplss_slide_link', true );
				$atts['logo_title'] 	= get_the_title();

				if( $count == 1 ){
					$first_last_cls = 'wpls-first';
				} elseif ( $count == $grid ) {
					$count = 0;
					$first_last_cls = 'wpls-last';
				}

				$atts['title_attr']	 	= ( $tooltip == 1 ) ? 'title="'.$atts['logo_title'].'"' : '';
				$atts['tooltip_cls'] 	= ( $atts['logo_title'] != '' && $tooltip == 1 ) ? 'wpls-tooltip' : '';
				$atts['cnt_wrp_cls'] 	= "{$grid_class} wpls-columns {$first_last_cls} {$atts['tooltip_cls']}";

				wpls_get_template( "widgets/grid/{$design}.php", $atts, null, null, "designs/{$design}.php" ); // loop designs

			endwhile;

			wpls_get_template( 'widgets/grid/loop-end.php', $atts ); // loop end

		} // End of have_post()

		wp_reset_postdata(); // Reset WP Query

		echo $after_widget;
	}
}