<?php
/**
 * 'logoshowcase' Shortcode
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Function to handle the `logoshowcase` shortcode
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
function wpls_pro_logo_slider( $atts, $content ) {

	// Shortcode Parameter
	$atts = shortcode_atts(array(
		'limit' 				=> 15,
		'cat_id' 				=> '',
		'include_cat_child'		=> 'true',
		'cat_name' 				=> '',
		'design'				=> 'design-1',
		'slides_column' 		=> 4,
		'slides_scroll' 		=> 1,
		'dots' 					=> 'true',
		'arrows' 				=> 'true',
		'autoplay' 				=> 'true',
		'rows' 					=> 1,
		'autoplay_interval' 	=> 3000,
		'speed' 				=> 600,
		'center_mode' 			=> 'false',
		'loop' 					=> 'true',
		'rtl'					=> '',
		'ticker'				=> 'false',
		'order'					=> 'DESC',
		'orderby'				=> 'date',
		'link_target'			=> 'self',
		'show_title' 			=> 'true',
		'image_size' 			=> 'full',
		'exclude_cat'			=> array(),
		'exclude_post'			=> array(),
		'posts'					=> array(),
		'animation'				=> '',
		'tooltip'				=> 'false',
		'content_words_limit' 	=> 20,
		'content_tail'			=> '...',
		'query_offset'			=> '',
		'extra_class'			=> '',
		), $atts, 'logoshowcase');
	
	$shortcode_designs				= wpls_pro_logo_designs();
	$atts['limit']					= !empty($atts['limit']) 					? $atts['limit'] 						: 15;
	$atts['cat_id']					= (!empty($atts['cat_id']))					? explode(',',$atts['cat_id']) 			: '';
	$atts['include_cat_child']		= ($atts['include_cat_child'] == 'false' ) 	? false 								: true;
	$atts['rows'] 					= !empty($atts['rows']) 					? $atts['rows'] 						: 1;
	$atts['slides_scroll'] 			= !empty($atts['slides_scroll']) 			? $atts['slides_scroll'] 				: 1;
	$atts['design'] 				= array_key_exists( trim($atts['design']), $shortcode_designs ) ? $atts['design'] 	: 'design-1';
	$atts['dots'] 					= ($atts['dots'] == 'false') 				? 'false' 								: 'true';
	$atts['arrows'] 				= ($atts['arrows'] == 'false') 				? 'false' 								: 'true';
	$atts['autoplay'] 				= ($atts['autoplay'] == 'false') 			? 'false' 								: 'true';
	$atts['order'] 					= (strtolower($atts['order']) == 'asc' ) 	? 'ASC' 								: 'DESC';
	$atts['orderby'] 				= !empty($atts['orderby']) 					? $atts['orderby'] 						: 'date';
	$atts['autoplay_interval'] 		= ($atts['autoplay_interval'] !== '') 		? $atts['autoplay_interval'] 			: 2000;
	$atts['speed'] 					= (!empty($atts['speed'])) 					? $atts['speed'] 						: 300;
	$atts['ticker']					= ($atts['ticker'] == 'true') 				? 'true' 								: 'false';
	$atts['loop'] 					= ($atts['loop'] == 'false') 				? 'false' 								: 'true';
	$atts['link_target'] 			= ($atts['link_target'] == 'blank') 		? '_blank' 								: '_self';
	$atts['show_title'] 			= ($atts['show_title'] == 'false') 			? 'false'								: 'true';
	$atts['image_size'] 			= (!empty($atts['image_size'])) 			? $atts['image_size']					: 'original';
	$atts['border_color'] 			= (!empty($atts['border_color'])) 			? $atts['border_color'] 				: '#ddd';
	$atts['exclude_cat'] 			= !empty($atts['exclude_cat'])				? explode(',', $atts['exclude_cat']) 	: array();
	$atts['exclude_post'] 			= !empty($atts['exclude_post'])				? explode(',', $atts['exclude_post']) 	: array();
	$atts['posts'] 					= !empty($atts['posts'])					? explode(',', $atts['posts']) 			: array();
	$atts['animation'] 				= !empty($atts['animation']) 				? $atts['animation'] 					: '';
	$atts['animation_cls'] 			= ($atts['animation'] == '') 				? 'has-no-animation'					: '';
	$atts['tooltip'] 				= ($atts['tooltip'] == 'true') 				? 'true' 								: 'false';
	$atts['content_words_limit'] 	= !empty( $atts['content_words_limit'] ) 	? $atts['content_words_limit'] 			: 20;
	$atts['query_offset']			= !empty($atts['query_offset'])				? $atts['query_offset'] 				: null;
	$atts['extra_class']			= wpls_pro_sanitize_html_classes($atts['extra_class']);
	$atts['content_tail'] 			= html_entity_decode($atts['content_tail']);

	// Extract Shortcode Var
	extract($atts);

	// For RTL
	if( empty($rtl) && is_rtl() ) {
		$rtl = 'true';
	} elseif ( $rtl == 'true' ) {
		$rtl = 'true';
	} else {
		$rtl = 'false';
	}
	
	// Little tweak for ticker mode
	if( $ticker	== 'true' ) {
		$autoplay 			= 'true';
		$slides_scroll 		= 1;
		$autoplay_interval 	= 0;
		$dots 				= 'false';
		$arrows 			= 'false';
		$loop 				= 'true';
	}

	// Enqueus required script
	if($tooltip == 'true') {
		wp_enqueue_script( 'wpos-tooltip-js' );
	}
	wp_enqueue_script( 'wpos-slick-jquery' );
	wp_enqueue_script( 'wpls-pro-public-js' );

	// Taking some globals
	global $post;

	// Taking some variables
	$atts['unique']	= wpls_pro_get_unique();
	
	// WP Query Parameters
	$query_args = array(
						'post_type' 			=> WPLS_PRO_POST_TYPE,
						'post_status' 			=> array( 'publish' ),
						'posts_per_page'		=> $limit,
						'order' 				=> $order,
						'orderby' 				=> $orderby,
						'post__in'				=> $posts,
						'post__not_in'			=> $exclude_post,
						'offset'				=> $query_offset,
						'ignore_sticky_posts'	=> true,
					);

	// Category Parameter
	if( !empty($cat_id) ) {

		$query_args['tax_query'] = array( 
										array(
											'taxonomy' 			=> WPLS_PRO_CAT, 
											'field' 			=> 'term_id',
											'terms' 			=> $cat_id,
											'include_children'	=> $include_cat_child,
										));

	} else if( !empty($exclude_cat) ) {

		$query_args['tax_query'] = array(
										array(
											'taxonomy' 			=> WPLS_PRO_CAT,
											'field' 			=> 'term_id',
											'terms' 			=> $exclude_cat,
											'operator'			=> 'NOT IN',
											'include_children'	=> $include_cat_child,
											));
	}
	
	// WP Query Parameters
	$logo_query = new WP_Query($query_args);

	// Template Variables 
	$post_count = $logo_query->post_count;

	// Slider configuration and taken care of centermode
	$slides_column 				= (!empty($slides_column) && $slides_column <= $post_count) ? $slides_column : $post_count;
	$center_mode				= ($center_mode == 'true' && $slides_column % 2 != 0 && $slides_column != $post_count) ? 'true' : 'false';
	$atts['center_mode_cls']	= ($center_mode == "true") ? 'wpls-center-mode' : '';

	// Slider variable
	$atts['logo_conf'] = compact('slides_column', 'slides_scroll', 'dots', 'arrows','rows', 'autoplay', 'autoplay_interval','ticker', 'speed', 'center_mode', 'loop','rtl');

	ob_start();

	// If post is there
	if( $logo_query->have_posts() ) {

		wpls_get_template( 'slider/loop-start.php', $atts ); // loop start

		while ($logo_query->have_posts()) : $logo_query->the_post();

			$atts['feat_image'] 	= wpls_pro_get_logo_image($post->ID, $image_size);
			$atts['logourl'] 		= get_post_meta( $post->ID, 'wplss_slide_link', true );
			$atts['logo_title'] 	= the_title_attribute( array('echo' => false) );
			$atts['cnt_wrp_cls'] 	= (!empty($atts['logo_title']) && $tooltip == "true") ? 'wpls-tooltip' : '';
			$atts['title_attr']	 	= ($tooltip == 'true') ? 'title="'.$atts['logo_title'].'"' : '';

			wpls_get_template( "slider/{$design}.php", $atts, null, null, "designs/{$design}.php" ); // loop designs

		endwhile;

		wpls_get_template( 'slider/loop-end.php', $atts ); // loop end

	}

	wp_reset_postdata(); // Reset WP Query

	$content .= ob_get_clean();
	return $content;
}

// `logoshowcase` slider shortcode
add_shortcode( 'logoshowcase', 'wpls_pro_logo_slider' );