<?php
/**
 * 'logo_grid' Shortcode
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Function to handle the `logo_grid` shortcode
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.0.0
 */
function wpls_pro_logo_grid( $atts, $content ) {

	// Shortcode Parameters
	$atts = shortcode_atts(array(
		'limit' 				=> 15,
		'cat_id' 				=> '',
		'include_cat_child'		=> 'true',
		'cat_name' 				=> '',
		'order'					=> 'DESC',
		'orderby'				=> 'date',
		'grid' 					=> 4,
		'link_target'			=> 'self',
		'show_title' 			=> 'true',
		'image_size' 			=> 'full',
		'design'				=> 'design-1',
		'exclude_cat'			=> array(),
		'exclude_post'			=> array(),
		'posts'					=> array(),
		'animation'				=> '',
		'tooltip'				=> 'false',
		'content_words_limit' 	=> 20,
		'content_tail'			=> '...',
		'pagination' 			=> 'true',
		'pagination_type'		=> 'numeric',
		'query_offset'			=> '',
		'extra_class'			=> '',
		), $atts, 'logo_grid');
	
	$shortcode_designs				= wpls_pro_logo_designs();
	$atts['unique'] 				= wpls_pro_get_unique();
	$atts['limit']					= !empty($atts['limit']) 					? $atts['limit'] 						: 15;
	$atts['order'] 					= (strtolower($atts['order']) == 'asc' ) 	? 'ASC' 								: 'DESC';
	$atts['orderby']				= !empty($atts['orderby']) 					? $atts['orderby'] 						: 'date';
	$atts['grid']					= (!empty($atts['grid']) && $atts['grid'] <= 12) ? $atts['grid'] 					: 4;
	$atts['design'] 				= array_key_exists( trim($atts['design']), $shortcode_designs ) ? $atts['design'] 	: 'design-1';
	$atts['grid_class']				= ($atts['grid'] <= 12 ) 					? ('wpls-col-'.($atts['grid'])) 		: 'wpls-col-4';
	$atts['link_target'] 			= ($atts['link_target'] == 'blank') 		? '_blank' 								: '_self';
	$atts['show_title'] 			= ($atts['show_title'] == 'false') 			? 'false'								: 'true';
	$atts['cat_id']					= (!empty($atts['cat_id']))					? explode(',',$atts['cat_id']) 			: '';
	$atts['include_cat_child']		= ($atts['include_cat_child'] == 'false' ) 	? false 								: true;
	$atts['exclude_cat'] 			= !empty($atts['exclude_cat'])				? explode(',', $atts['exclude_cat']) 	: array();
	$atts['exclude_post']			= !empty($atts['exclude_post'])				? explode(',', $atts['exclude_post']) 	: array();
	$atts['posts'] 					= !empty($atts['posts'])					? explode(',', $atts['posts']) 			: array();
	$atts['animation'] 				= !empty($atts['animation']) 				? $atts['animation'] 					: '';
	$atts['animation_cls'] 			= ($atts['animation'] == "") 				? 'has-no-animation'					: '';
	$atts['tooltip'] 				= ($atts['tooltip'] == 'true') 				? 'true' 								: 'false';
	$atts['content_words_limit'] 	= !empty( $atts['content_words_limit'] ) 	? $atts['content_words_limit'] 			: 20;
	$atts['pagination'] 			= ($atts['pagination'] == 'false')			? false									: true;
	$atts['pagination_type'] 		= ($atts['pagination_type'] == 'prev-next')	? 'prev-next' 							: 'numeric';
	$atts['query_offset']			= !empty($atts['query_offset'])				? $atts['query_offset'] 				: null;
	$atts['extra_class']			= wpls_pro_sanitize_html_classes( $atts['extra_class'] );
	$atts['content_tail'] 			= html_entity_decode( $atts['content_tail'] );

	// Extract Shortcode Var
	extract($atts);

	// Enqueus required script
	if($tooltip == 'true') {
		wp_enqueue_script( 'wpos-tooltip-js' );
	}
	wp_enqueue_script( 'wpls-pro-public-js' );

	// Taking some globals
	global $post;

	// Pagination Parameter
	if ( get_query_var( 'paged' ) ) {
		$atts['paged'] = get_query_var('paged');
	} else if ( get_query_var( 'page' ) ) {
		$atts['paged'] = get_query_var( 'page' );
	} else {
		$atts['paged'] = 1;
	}

	// Taking some variables
	$count = 1;

	// WP Query Parameters
	$query_args = array(
			'post_type' 			=> WPLS_PRO_POST_TYPE,
			'post_status' 			=> array( 'publish' ),
			'posts_per_page'		=> $limit,
			'order'          		=> $order,
			'orderby'        		=> $orderby,
			'paged'          		=> ( $pagination ) ? $atts['paged'] : 1,
			'post__not_in'			=> $exclude_post,
			'post__in'				=> $posts,
			'offset'				=> $query_offset,
			'ignore_sticky_posts'	=> true,
		);

	// Category Parameter
	if( !empty($cat_id) ) {

		$query_args['tax_query'] = array( 
										array(
											'taxonomy' 			=> WPLS_PRO_CAT, 
											'field' 			=> 'term_id',
											'terms' 			=> $cat_id,
											'include_children'	=> $include_cat_child,
										));

	} else if( !empty($exclude_cat) ) {

		$query_args['tax_query'] = array(
										array(
											'taxonomy' 			=> WPLS_PRO_CAT,
											'field' 			=> 'term_id',
											'terms' 			=> $exclude_cat,
											'operator'			=> 'NOT IN',
											'include_children'	=> $include_cat_child,
											));
	}

	// WP Query
	$logo_query = new WP_Query($query_args);

	// Template Variable
	$atts['max_num_pages'] 	= $logo_query->max_num_pages;

	ob_start();

	// If post is there
	if( $logo_query->have_posts() ) {

		wpls_get_template( 'grid/loop-start.php', $atts ); // loop start

		while ($logo_query->have_posts()) : $logo_query->the_post();

			$first_last_cls 		= '';
			$atts['feat_image'] 	= wpls_pro_get_logo_image($post->ID,$image_size);
			$atts['logourl'] 		= get_post_meta( get_the_ID(), 'wplss_slide_link', true );
			$atts['logo_title'] 	= the_title_attribute( array('echo' => false) );

			if( $count == 1 ){
				$first_last_cls = 'wpls-first';
			} elseif ( $count == $grid ) {
				$count = 0;
				$first_last_cls = 'wpls-last';
			}

			$tooltip_cls 			= ( $atts['logo_title'] != '' && $tooltip == "true" ) ? 'wpls-tooltip' : '';
			$atts['title_attr']	 	= ( $tooltip == 'true' ) ? 'title="'.$atts['logo_title'].'"' : '';
			$atts['cnt_wrp_cls'] 	= "{$grid_class} wpls-columns {$first_last_cls} {$tooltip_cls}";

			wpls_get_template( "grid/{$design}.php", $atts, null, null, "designs/{$design}.php" ); // loop designs

			$count++;

		endwhile;

		wpls_get_template( 'grid/loop-end.php', $atts ); // loop end
	}

	wp_reset_postdata(); // Reset WP Query

	$content .= ob_get_clean();
	return $content;
}

// `logo_grid` slider shortcode
add_shortcode('logo_grid', 'wpls_pro_logo_grid');