<?php
/**
 * Shortcode Fields for Shortcode Preview
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.3.4
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Generate 'logoshowcase' shortcode fields for preview
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.3.4
 */
function logoshowcase_shortcode_fields( $shortcode ) {

	$fields = array(
			// General fields
			'general' => array(
					'title'     => __('General Parameters', 'logoshowcase'),
					'params'   	=>  array(
									// General settings
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Title', 'logoshowcase' ),
										'name' 		=> 'cat_name',
										'value' 	=> '',
										'desc' 		=> __( 'Display title above logo showcase.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Design', 'logoshowcase' ),
										'name' 		=> 'design',
										'value' 	=> array(
															'design-1'	=> __( 'Slider Design 1', 'logoshowcase' ),
															'design-2'	=> __( 'Slider Design 2', 'logoshowcase' ),
															'design-3'	=> __( 'Slider Design 3', 'logoshowcase' ),
															'design-4'	=> __( 'Slider Design 4', 'logoshowcase' ),
															'design-5'	=> __( 'Slider Design 5', 'logoshowcase' ),
															'design-6'	=> __( 'Slider Design 6', 'logoshowcase' ),
															'design-7'	=> __( 'Slider Design 7', 'logoshowcase' ),
															'design-8'	=> __( 'Slider Design 8', 'logoshowcase' ),
															'design-9'	=> __( 'Slider Design 9', 'logoshowcase' ),
															'design-10'	=> __( 'Slider Design 10', 'logoshowcase' ),
															'design-11'	=> __( 'Slider Design 11', 'logoshowcase' ),
															'design-12'	=> __( 'Slider Design 12', 'logoshowcase' ),
															'design-13'	=> __( 'Slider Design 13', 'logoshowcase' ),
															'design-14'	=> __( 'Slider Design 14', 'logoshowcase' ),
															'design-15'	=> __( 'Slider Design 15', 'logoshowcase' ),
															'design-16'	=> __( 'Slider Design 16', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose design.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Animation Effect', 'logoshowcase' ),
										'name' 		=> 'animation',
										'value' 	=> array(
															''				=> __( 'Select Animation Effect', 'logoshowcase' ),
															'flash'			=> __( 'Flash', 'logoshowcase' ),
															'pulse'			=> __( 'Pulse', 'logoshowcase' ),
															'rubberBand'	=> __( 'Rubber Band', 'logoshowcase' ),
															'headShake'		=> __( 'Head Shake', 'logoshowcase' ),
															'swing'			=> __( 'Swing', 'logoshowcase' ),
															'tada'			=> __( 'Tada', 'logoshowcase' ),
															'wobble'		=> __( 'Wobble', 'logoshowcase' ),
															'jello'			=> __( 'Jello', 'logoshowcase' ),
															'bounceIn'		=> __( 'Bounce In', 'logoshowcase' ),
															'fadeIn'		=> __( 'Fade In', 'logoshowcase' ),
															'fadeOut'		=> __( 'Fade Out', 'logoshowcase' ),
															'lightSpeedOut'	=> __( 'Light Speed Out', 'logoshowcase' ),
															'rotateIn'		=> __( 'Rotate In', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose animation effect.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Show Title', 'logoshowcase' ),
										'name' 		=> 'show_title',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Display title.', 'logoshowcase' )
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Show Tooltip', 'logoshowcase' ),
										'name' 		=> 'tooltip',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'default'	=> 'false',
										'desc' 		=> __( 'Display tooltip.', 'logoshowcase' )
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Content Words Limit', 'logoshowcase' ),
										'name' 		=> 'content_words_limit',
										'value' 	=> 20,
										'desc' 		=> __( 'Control post content words limit.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 	=> 'design',
															'value' 	=> array( 'design-4' ),
															),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Content Tail', 'logoshowcase' ),
										'name' 		=> 'content_tail',
										'value' 	=> '...',
										'desc' 		=> __( 'Display dots after the post content.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 	=> 'design',
															'value' 	=> array( 'design-4' ),
														),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Link Behaviour', 'logoshowcase' ),
										'name' 		=> 'link_target',
										'value' 	=> array(
															'self'	=> __( 'Same Window', 'logoshowcase' ),
															'blank'	=> __( 'New Window', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose link bahaviour.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Image Size', 'logoshowcase' ),
										'name' 		=> 'image_size',
										'value' 	=> '',
										'desc' 		=> __( 'Choose WordPress registered image size. e.g', 'logoshowcase' ).' thumbnail, medium, large, full.',
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Extra Class', 'logoshowcase' ),
										'name' 		=> 'extra_class',
										'value' 	=> '',
										'desc' 		=> __( 'Enter extra CSS class for design customization.', 'logoshowcase' ) . '<label title="'.__('Note: Extra class added as parent so using extra class you customize your design.', 'logoshowcase').'"> [?]</label>',
									),
								),						
			),

			//Slider Fields
			'slider' => array(
					'title'		=> __('Slider Parameters', 'logoshowcase'),
					'params'    => array(
									// Slider Settings
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Slides Column', 'logoshowcase' ),
										'name' 		=> 'slides_column',
										'value' 	=> 4,
										'desc' 		=> __( 'Enter number of column for slider.', 'logoshowcase' ),
									),
									array(
										'type' 			=> 'number',
										'heading' 		=> __( 'Slides Rows', 'logoshowcase' ),
										'name' 			=> 'rows',
										'value' 		=> 1,
										'min'			=> 1,
										'description' 	=> __( 'Enter number of rows for slider.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Slides Scroll', 'logoshowcase' ),
										'name' 		=> 'slides_scroll',
										'value' 	=> 1,
										'desc' 		=> __( 'Enter number of slide to scroll at a time.', 'logoshowcase' ),
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Dots', 'logoshowcase' ),
										'name' 		=> 'dots',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Show pagination dots.', 'logoshowcase' ),
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Arrows', 'logoshowcase' ),
										'name' 		=> 'arrows',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Show prev - next arrows.', 'logoshowcase' ),
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Autoplay', 'logoshowcase' ),
										'name' 		=> 'autoplay',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Enable autoplay.', 'logoshowcase' ),
										
									),
									array(
										'type' 			=> 'number',
										'heading' 		=> __( 'Autoplay Interval', 'logoshowcase' ),
										'name' 			=> 'autoplay_interval',
										'value' 		=> 3000,
										'desc' 			=> __( 'Enter autoplay speed.', 'logoshowcase' ),
										'dependency' 	=> array(
																'element' 	=> 'autoplay',
																'value' 	=> array( 'true' ),
															),
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Speed', 'logoshowcase' ),
										'name' 		=> 'speed',
										'value' 	=> 600,
										'desc' 		=> __( 'Enter slide speed.', 'logoshowcase' ),
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Center Mode', 'logoshowcase' ),
										'name' 		=> 'center_mode',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'default'	=> 'false',
										'desc' 		=> __( 'Enable center mode for slider.', 'logoshowcase' ) . '<label title="'.__('Note: Works well with odd number of Slides Column and Slides Scroll is set to 1.', 'logoshowcase').'"> [?]</label>',
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Infinite', 'logoshowcase' ),
										'name' 		=> 'loop',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Enable infinite loop sliding.', 'logoshowcase' ),
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Ticker Mode', 'logoshowcase' ),
										'name' 		=> 'ticker',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'default'	=> 'false',
										'desc' 		=> __( 'Enable ticker mode for slider.', 'logoshowcase' ) . '<label title="'.__('Note: When you enable ticker mode Autoplay, Slides Scroll and Autoplay Interval will set to default.', 'logoshowcase').'"> [?]</label>',
										
									),	
								)
			),

			// Query Fields
			'query' => array(
					'title'		=> __('Query Parameters', 'logoshowcase'),
					'params'    => array(
									// Query Settings
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Total items', 'logoshowcase' ),
										'name' 		=> 'limit',
										'value' 	=> 15,
										'min'		=> -1,
										'desc' 		=> __( 'Enter number of logo to be displayed. Enter -1 to display all.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Order By', 'logoshowcase' ),
										'name' 		=> 'orderby',
										'value' 	=> array(
															'date'		=> __( 'Post Date', 'logoshowcase' ),
															'ID'		=> __( 'Post ID', 'logoshowcase' ),
															'author'	=> __( 'Post Author', 'logoshowcase' ),
															'title'		=> __( 'Post Title', 'logoshowcase' ),
															'modified'	=> __( 'Post Modified Date', 'logoshowcase' ),
															'rand'		=> __( 'Random', 'logoshowcase' ),
															'menu_order'=> __( 'Menu Order', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Select order type.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Sort order', 'logoshowcase' ),
										'name' 		=> 'order',
										'value' 	=> array(
															'desc'	=> __( 'Descending', 'logoshowcase' ),
															'asc'	=> __( 'Ascending', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Select sorting order.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Category', 'logoshowcase' ),
										'name' 		=> 'cat_id',
										'value' 	=> '',
										'desc' 		=> __( 'Enter category id to display categories wise.', 'logoshowcase' ) . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant category listing page.', 'logoshowcase').'"> [?]</label>',
										
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Include Category Children', 'logoshowcase' ),
										'name' 		=> 'include_cat_child',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'If you are using parent category then whether to display child category or not.', 'logoshowcase' ),
										
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Exclude Category', 'logoshowcase' ),
										'name' 		=> 'exclude_cat',
										'value' 	=> '',
										'desc' 		=> __( 'Exclude post category. Works only if `Category` field is empty.', 'logoshowcase' ) . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant category listing page.', 'logoshowcase').'"> [?]</label>',
										
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Display Specific Post', 'logoshowcase' ),
										'name' 		=> 'posts',
										'value' 	=> '',
										'desc' 		=> __('Enter id of the post which you want to display.', 'logoshowcase') . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant post listing page.', 'logoshowcase').'"> [?]</label>',
										
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Exclude Post', 'logoshowcase' ),
										'name' 		=> 'exclude_post',
										'value' 	=> '',
										'desc' 		=> __('Enter id of the post which you do not want to display.', 'logoshowcase') . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant post listing page.', 'logoshowcase').'"> [?]</label>',
										
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Query Offset', 'logoshowcase' ),
										'name' 		=> 'query_offset',
										'value' 	=> '',
										'desc' 		=> __( 'Exclude number of posts from starting.', 'logoshowcase' ) . '<label title="'.__('e.g if you pass 5 then it will skip first five post. Note: Do not use limit=-1 and pagination=true with this.', 'logoshowcase').'"> [?]</label>',
										
									),	
								)
			),
	);
	return $fields;
}
/**
 * Generate 'logo_grid' shortcode fields for preview
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.3.4
 */
function logo_grid_shortcode_fields( $shortcode ) {

	$fields = array(
			// General fields
			'general' => array(
					'title'     => __('General Parameters', 'logoshowcase'),
					'params'    =>  array(
									// General settings
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Title', 'logoshowcase' ),
										'name' 		=> 'cat_name',
										'value' 	=> '',
										'desc' 		=> __( 'Display title above logo showcase.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Design', 'logoshowcase' ),
										'name' 		=> 'design',
										'value' 	=> array(
															'design-1'	=> __( 'Grid Design 1', 'logoshowcase' ),
															'design-2'	=> __( 'Grid Design 2', 'logoshowcase' ),
															'design-3'	=> __( 'Grid Design 3', 'logoshowcase' ),
															'design-4'	=> __( 'Grid Design 4', 'logoshowcase' ),
															'design-5'	=> __( 'Grid Design 5', 'logoshowcase' ),
															'design-6'	=> __( 'Grid Design 6', 'logoshowcase' ),
															'design-7'	=> __( 'Grid Design 7', 'logoshowcase' ),
															'design-8'	=> __( 'Grid Design 8', 'logoshowcase' ),
															'design-9'	=> __( 'Grid Design 9', 'logoshowcase' ),
															'design-10'	=> __( 'Grid Design 10', 'logoshowcase' ),
															'design-11'	=> __( 'Grid Design 11', 'logoshowcase' ),
															'design-12'	=> __( 'Grid Design 12', 'logoshowcase' ),
															'design-13'	=> __( 'Grid Design 13', 'logoshowcase' ),
															'design-14'	=> __( 'Grid Design 14', 'logoshowcase' ),
															'design-15'	=> __( 'Grid Design 15', 'logoshowcase' ),
															'design-16'	=> __( 'Grid Design 16', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose design.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Animation Effect', 'logoshowcase' ),
										'name' 		=> 'animation',
										'value' 	=> array(
															''				=> __( 'Select Animation Effect', 'logoshowcase' ),
															'flash'			=> __( 'Flash', 'logoshowcase' ),
															'pulse'			=> __( 'Pulse', 'logoshowcase' ),
															'rubberBand'	=> __( 'Rubber Band', 'logoshowcase' ),
															'headShake'		=> __( 'Head Shake', 'logoshowcase' ),
															'swing'			=> __( 'Swing', 'logoshowcase' ),
															'tada'			=> __( 'Tada', 'logoshowcase' ),
															'wobble'		=> __( 'Wobble', 'logoshowcase' ),
															'jello'			=> __( 'Jello', 'logoshowcase' ),
															'bounceIn'		=> __( 'Bounce In', 'logoshowcase' ),
															'fadeIn'		=> __( 'Fade In', 'logoshowcase' ),
															'fadeOut'		=> __( 'Fade Out', 'logoshowcase' ),
															'lightSpeedOut'	=> __( 'Light Speed Out', 'logoshowcase' ),
															'rotateIn'		=> __( 'Rotate In', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose animation effect.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Logo Columns Grid', 'logoshowcase' ),
										'name' 		=> 'grid',
										'value' 	=> 4,
										'desc' 		=> __( 'Control logo columns. Maximum grid is up to 12.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Show Title', 'logoshowcase' ),
										'name' 		=> 'show_title',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Display title.', 'logoshowcase' )
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Show Tooltip', 'logoshowcase' ),
										'name' 		=> 'tooltip',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),	
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'default'	=> 'false',
										'desc' 		=> __( 'Display tooltip.', 'logoshowcase' )
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Content Words Limit', 'logoshowcase' ),
										'name' 		=> 'content_words_limit',
										'value' 	=> 20,
										'desc' 		=> __( 'Control post content words limit.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 	=> 'design',
															'value' 	=> array( 'design-4' ),
														),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Content Tail', 'logoshowcase' ),
										'name' 		=> 'content_tail',
										'value' 	=> '...',
										'desc' 		=> __( 'Display dots after the post content.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 	=> 'design',
															'value' 	=> array( 'design-4' ),
														),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Link Behaviour', 'logoshowcase' ),
										'name' 		=> 'link_target',
										'value' 	=> array(
															'self'	=> __( 'Same Window', 'logoshowcase' ),
															'blank'	=> __( 'New Window', 'logoshowcase' ) ,
														),
										'desc' 		=> __( 'Choose link bahaviour.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Image Size', 'logoshowcase' ),
										'name' 		=> 'image_size',
										'value' 	=> '',
										'desc' 		=> __( 'Choose WordPress registered image size. e.g', 'logoshowcase' ).' thumbnail, medium, large, full.',
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Extra Class', 'logoshowcase' ),
										'name' 		=> 'extra_class',
										'value' 	=> '',
										'desc' 		=> __( 'Enter extra CSS class for design customization.', 'logoshowcase' ) . '<label title="'.__('Note: Extra class added as parent so using extra class you customize your design.', 'logoshowcase').'"> [?]</label>',
									),		
								)						
			),
			// Query Fields
			'query' => array(
					'title'		=> __('Query Parameters', 'logoshowcase'),
					'params'    => array(
									// Query Settings
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Total items', 'logoshowcase' ),
										'name' 		=> 'limit',
										'value' 	=> 15,
										'min'		=> -1,
										'desc' 		=> __( 'Enter number of logo to be displayed. Enter -1 to display all.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Order By', 'logoshowcase' ),
										'name' 		=> 'orderby',
										'value' 	=> array(
															'date'		=> __( 'Post Date', 'logoshowcase' ) 	,
															'ID'		=> __( 'Post ID', 'logoshowcase' ) 	,
															'author'	=> __( 'Post Author', 'logoshowcase' ) ,
															'title'		=> __( 'Post Title', 'logoshowcase' ) 	,
															'modified'	=> __( 'Post Modified Date', 'logoshowcase' ),
															'rand'		=> __( 'Random', 'logoshowcase' ) 		,
															'menu_order'=> __( 'Menu Order', 'logoshowcase' ) 	,
														),
										'desc' 		=> __( 'Select order type.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Sort order', 'logoshowcase' ),
										'name' 		=> 'order',
										'value' 	=> array(
															'desc'	=> __( 'Descending', 'logoshowcase' ),
															'asc'	=> __( 'Ascending', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Select sorting order.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Category', 'logoshowcase' ),
										'name' 		=> 'cat_id',
										'value' 	=> '',
										'desc' 		=> __( 'Enter category id to display categories wise.', 'logoshowcase' ) . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant category listing page.', 'logoshowcase').'"> [?]</label>',
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Include Category Children', 'logoshowcase' ),
										'name' 		=> 'include_cat_child',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ) ,
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'If you are using parent category then whether to display child category or not.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Exclude Category', 'logoshowcase' ),
										'name' 		=> 'exclude_cat',
										'value' 	=> '',
										'desc' 		=> __( 'Exclude post category. Works only if `Category` field is empty.', 'logoshowcase' ) . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant category listing page.', 'logoshowcase').'"> [?]</label>',
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Display Specific Post', 'logoshowcase' ),
										'name' 		=> 'posts',
										'value' 	=> '',
										'desc' 		=> __('Enter id of the post which you want to display.', 'logoshowcase') . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant post listing page.', 'logoshowcase').'"> [?]</label>',
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Exclude Post', 'logoshowcase' ),
										'name' 		=> 'exclude_post',
										'value' 	=> '',
										'desc' 		=> __('Enter id of the post which you do not want to display.', 'logoshowcase') . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant post listing page.', 'logoshowcase').'"> [?]</label>',
									),

									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Pagination', 'logoshowcase' ),
										'name' 		=> 'pagination',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'dependency'=> array(
															'element' 				=> 'limit',
															'value_not_equal_to' 	=> array( '-1' ),
														),
										'desc' 		=> __( 'Enable pagination.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Pagination Type', 'logoshowcase' ),
										'name' 		=> 'pagination_type',
										'value' 	=> array(
															'numeric'	=> __( 'Numeric', 'logoshowcase' ) ,
															'prev-next'	=> __( 'Next - Prev', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose pagination type.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 				=> 'pagination',
															'value_not_equal_to' 	=> array( 'false' ),
														),
									),

									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Query Offset', 'logoshowcase' ),
										'name' 		=> 'query_offset',
										'value' 	=> '',
										'desc' 		=> __( 'Exclude number of posts from starting.', 'logoshowcase' ) . '<label title="'.__('e.g if you pass 5 then it will skip first five post. Note: Do not use limit=-1 and pagination=true with this.', 'logoshowcase').'"> [?]</label>',
									),
								)
			),
	);
	return $fields;
}
/**
 * Generate 'logo_filter' shortcode fields for preview
 * 
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.3.4
 */
function logo_filter_shortcode_fields( $shortcode ) {

	$fields = array(
			// General fields
			'general' => array(
					'title'     => __('General Parameters', 'logoshowcase'),
					'params'    =>  array(
									// General settings
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Title', 'logoshowcase' ),
										'name' 		=> 'cat_name',
										'value' 	=> '',
										'desc' 		=> __( 'Display title above logo showcase.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Design', 'logoshowcase' ),
										'name' 		=> 'design',
										'value' 	=> array(
															'design-1'	=> __( 'Filter Design 1', 'logoshowcase' ),
															'design-2'	=> __( 'Filter Design 2', 'logoshowcase' ),
															'design-3'	=> __( 'Filter Design 3', 'logoshowcase' ),
															'design-4'	=> __( 'Filter Design 4', 'logoshowcase' ),
															'design-5'	=> __( 'Filter Design 5', 'logoshowcase' ),
															'design-6'	=> __( 'Filter Design 6', 'logoshowcase' ),
															'design-7'	=> __( 'Filter Design 7', 'logoshowcase' ),
															'design-8'	=> __( 'Filter Design 8', 'logoshowcase' ),
															'design-9'	=> __( 'Filter Design 9', 'logoshowcase' ),
															'design-10'	=> __( 'Filter Design 10', 'logoshowcase' ),
															'design-11'	=> __( 'Filter Design 11', 'logoshowcase' ),
															'design-12'	=> __( 'Filter Design 12', 'logoshowcase' ),
															'design-13'	=> __( 'Filter Design 13', 'logoshowcase' ),
															'design-14'	=> __( 'Filter Design 14', 'logoshowcase' ),
															'design-15'	=> __( 'Filter Design 15', 'logoshowcase' ),
															'design-16'	=> __( 'Filter Design 16', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Choose design.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Logo Columns Grid', 'logoshowcase' ),
										'name' 		=> 'grid',
										'value' 	=> 4,
										'desc' 		=> __( 'Control logo columns. Maximum grid is up to 12.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Show Title', 'logoshowcase' ),
										'name' 		=> 'show_title',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Display title.', 'logoshowcase' )
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Show Tooltip', 'logoshowcase' ),
										'name' 		=> 'tooltip',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'default'	=> 'false',
										'desc' 		=> __( 'Display tooltip.', 'logoshowcase' )
									),
									array(
										'type' 		=> 'number',
										'heading' 	=> __( 'Content Words Limit', 'logoshowcase' ),
										'name' 		=> 'content_words_limit',
										'value' 	=> 20,
										'desc' 		=> __( 'Control post content words limit.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 	=> 'design',
															'value' 	=> array( 'design-4' ),
														),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Content Tail', 'logoshowcase' ),
										'name' 		=> 'content_tail',
										'value' 	=> '...',
										'desc' 		=> __( 'Display dots after the post content.', 'logoshowcase' ),
										'dependency'=> array(
															'element' 	=> 'design',
															'value' 	=> array( 'design-4' ),
														),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Link Behaviour', 'logoshowcase' ),
										'name' 		=> 'link_target',
										'value' 	=> array(
															'self'	=> __( 'Same Window', 'logoshowcase' ),
															'blank'	=> __( 'New Window', 'logoshowcase' ) ,
														),
										'desc' 		=> __( 'Choose link bahaviour.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'All Category Filter Text', 'logoshowcase' ),
										'name' 		=> 'all_filter_text',
										'value' 	=> __('All', 'logoshowcase'),
										'desc' 		=> __( 'Control all category filter text.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Image Size', 'logoshowcase' ),
										'name' 		=> 'image_size',
										'value' 	=> '',
										'desc' 		=> __( 'Choose WordPress registered image size. e.g', 'logoshowcase' ).' thumbnail, medium, large, full.',
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Extra Class', 'logoshowcase' ),
										'name' 		=> 'extra_class',
										'value' 	=> '',
										'desc' 		=> __( 'Enter extra CSS class for design customization.', 'logoshowcase' ) . '<label title="'.__('Note: Extra class added as parent so using extra class you customize your design.', 'logoshowcase').'"> [?]</label>',
									),
								)						
			),
			// Query Fields
			'query' => array(
					'title'		=> __('Query Parameters', 'logoshowcase'),
					'params'    => array(
									// Query Settings
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Post Order By', 'logoshowcase' ),
										'name' 		=> 'orderby',
										'value' 	=> array(
															'date'		=> __( 'Post Date', 'logoshowcase' ) 	,
															'ID'		=> __( 'Post ID', 'logoshowcase' ) 	,
															'author'	=> __( 'Post Author', 'logoshowcase' ) ,
															'title'		=> __( 'Post Title', 'logoshowcase' ) 	,
															'modified'	=> __( 'Post Modified Date', 'logoshowcase' ),
															'rand'		=> __( 'Random', 'logoshowcase' ) 		,
															'menu_order'=> __( 'Menu Order', 'logoshowcase' ) 	,
														),
										'desc' 		=> __( 'Select order type.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Post Sort order', 'logoshowcase' ),
										'name' 		=> 'order',
										'value' 	=> array(
															'desc'	=> __( 'Descending', 'logoshowcase' ),
															'asc'	=> __( 'Ascending', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Select sorting order.', 'logoshowcase' ),
									),
									array(
										'type' 			=> 'number',
										'heading' 		=> __( 'Category Limit', 'logoshowcase' ),
										'name' 			=> 'cat_limit',
										'value' 		=> 0,
										'description' 	=> __( 'Enter number of categories to be displayed.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Category Order By', 'logoshowcase' ),
										'name' 		=> 'cat_orderby',
										'value' 	=> array(
															'name'		=> __( 'Category Name', 'logoshowcase' ),
															'term_id'	=> __( 'Category ID', 'logoshowcase' ),
															'count'		=> __( 'Count', 'logoshowcase' ) 	,
														),
										'desc' 		=> __( 'Select category order type.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Category Sort order', 'logoshowcase' ),
										'name' 		=> 'cat_order',
										'value' 	=> array(
															'asc'	=> __( 'Ascending', 'logoshowcase' ),
															'desc'	=> __( 'Descending', 'logoshowcase' ),
														),
										'desc' 		=> __( 'Select category sorting order.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Category', 'logoshowcase' ),
										'name' 		=> 'cat_id',
										'value' 	=> '',
										'desc' 		=> __( 'Enter category id to display categories wise.', 'logoshowcase' ) . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant category listing page.', 'logoshowcase').'"> [?]</label>',
									),
									array(
										'type' 		=> 'dropdown',
										'heading' 	=> __( 'Include Category Children', 'logoshowcase' ),
										'name' 		=> 'include_cat_child',
										'value' 	=> array(
															'true'	=> __( 'True', 'logoshowcase' ),
															'false'	=> __( 'False', 'logoshowcase' ),
														),
										'desc' 		=> __( 'If you are using parent category then whether to display child category or not.', 'logoshowcase' ),
									),
									array(
										'type' 		=> 'text',
										'heading' 	=> __( 'Exclude Category', 'logoshowcase' ),
										'name' 		=> 'exclude_cat',
										'value' 	=> '',
										'desc' 		=> __( 'Exclude post category. Works only if `Category` field is empty.', 'logoshowcase' ) . '<label title="'.__('You can pass multiple ids with comma seperated. You can find id at relevant category listing page.', 'logoshowcase').'"> [?]</label>',
									),
								)
			),
	);
	return $fields;
}