<?php
/**
 * WP Logo Showcase Responsive Slider Pro Shortcode Mapper Page
 *
 * @package WP Logo Showcase Responsive Slider Pro
 * @since 1.3.4
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$registered_shortcodes 	= wpls_pro_registered_shortcodes();
$preview_shortcode 		= !empty($_GET['shortcode']) ? $_GET['shortcode'] : apply_filters('wpls_default_shortcode_preview', 'logoshowcase' );
$preview_url 			= add_query_arg( array( 'page' => 'wpls-preview', 'shortcode' => $preview_shortcode), admin_url('admin.php') );
$shrt_generator_url 	= add_query_arg( array('post_type' => WPLS_PRO_POST_TYPE, 'page' => 'wpls-shrt-mapper'), admin_url('edit.php') );

// Instantiate the shortcode mapper
if( !class_exists( 'Wpls_Pro_Shortcode_Mapper' ) ) {
	include_once( WPLS_PRO_DIR . '/includes/admin/shortcode-mapper/class-wpls-shortcode-mapper.php' );
}

$shortcode_fields 	= array();
$shortcode_sanitize = str_replace('-', '_', $preview_shortcode);
?>
<div class="wrap wpls-customizer-settings">
	<h2><?php _e( 'Logo - Shortcode Generator', 'logoshowcase' ); ?></h2>
	<?php
	// If invalid shortocde is passed then simply return
	if( !empty($_GET['shortcode']) && !isset( $registered_shortcodes[ $_GET['shortcode'] ] ) ) {
		echo '<div id="message" class="error notice">
				<p><strong>'.__('Sorry, Something happened wrong.', 'logoshowcase').'</strong></p>
			 </div>';
		return;
	}
	?>

	<div class="wpls-customizer-toolbar">
		<?php if( !empty( $registered_shortcodes ) ) { ?>
			<select class="wpls-cust-shrt-switcher" id="wpls-cust-shrt-switcher">
				<option value=""><?php _e('-- Choose Shortcode --', 'logoshowcase'); ?></option>
				<?php foreach ($registered_shortcodes as $shrt_key => $shrt_val) {

					if( empty($shrt_key) ) {
						continue;
					}

					$shrt_val 		= !empty($shrt_val) ? $shrt_val : $shrt_key;
					$shortcode_url 	= add_query_arg( array('shortcode' => $shrt_key), $shrt_generator_url );
				?>
				<option value="<?php echo $shrt_key; ?>" <?php selected( $preview_shortcode, $shrt_key); ?> data-url="<?php echo esc_url( $shortcode_url ); ?>"><?php echo $shrt_val; ?></option>
				<?php } ?>
			</select>
		<?php } ?>
		<span class="wpls-cust-shrt-generate-help wpls-tooltip" title="<?php _e("The Shortcode Mapper allows you to preview plugin shortcode. You can choose your desired shortcode from the dropdown and check various parameters from left panel. \n\nYou can paste shortocde to below and press Generate button to preview so each and every time you do not have to choose each parameters!!!", 'logoshowcase'); ?>"><i class="dashicons dashicons-editor-help"></i></span>
	</div><!-- end .wpls-customizer-toolbar -->

	<div class="wpls-customizer wpls-clearfix" data-shortcode="<?php echo $preview_shortcode; ?>">
		<div class="wpls-customizer-control wpls-clearfix">
			<div class="wpls-customizer-heading"><?php _e('Shortcode Parameters', 'logoshowcase'); ?></div>
			<?php
				if ( function_exists( $shortcode_sanitize.'_shortcode_fields' ) ) {
					$shortcode_fields = call_user_func( $shortcode_sanitize.'_shortcode_fields', $preview_shortcode );
				}
				$shortcode_fields = apply_filters('wpls_pro_shortcode_mapper_fields', $shortcode_fields, $preview_shortcode );

				$shortcode_mapper = new Wpls_Pro_Shortcode_Mapper();
				$shortcode_mapper->render( $shortcode_fields );
			?>
		</div>

		<div class="wpls-customizer-preview wpls-clearfix">
			<div class="wpls-customizer-shrt-wrp">
				<div class="wpls-customizer-heading"><?php _e('Shortcode', 'logoshowcase'); ?> 
					<div class="wpls-customizer-shrt-tool">
						<button type="button" class="button button-primary button-small wpls-cust-shrt-generate"><?php _e('Generate', 'logoshowcase') ?></button>
						<i title="<?php _e('Full Preview Mode', 'logoshowcase'); ?>" class="wpls-tooltip wpls-cust-dwp dashicons dashicons-editor-expand"></i>
					</div>
				</div>
				<form action="<?php echo esc_url($preview_url); ?>" method="post" class="wpls-customizer-shrt-form" id="wpls-customizer-shrt-form" target="wpls_customizer_preview_frame">
					<textarea name="wpls_customizer_shrt" class="wpls-customizer-shrt" id="wpls-customizer-shrt" placeholder="<?php _e('Copy or Paste Shortcode', 'logoshowcase'); ?>"></textarea>
				</form>
			</div>
			<div class="wpls-customizer-heading"><?php _e('Preview Window', 'logoshowcase'); ?> <span class="wpls-cust-heading-info wpls-tooltip" title="<?php _e('Preview will be displayed according to responsive layout mode. You can check with `Full Preview` mode for better visualization.', 'logoshowcase'); ?>">[?]</span></div>
			<div class="wpls-customizer-window">
				<iframe class="wpls-customizer-preview-frame" name="wpls_customizer_preview_frame" src="<?php echo esc_url($preview_url); ?>" scrolling="auto" frameborder="0"></iframe>
				<div class="wpls-customizer-loader"></div>
				<div class="wpls-customizer-error"><?php _e('Sorry, Something happened wrong.', 'logoshowcase'); ?></div>
			</div>
		</div>
	</div><!-- wpls-customizer -->

	<br/>
	<div class="wpls-cust-footer-note"><span class="description"><?php _e('Note: Preview will be displayed according to responsive layout mode. Live preview may display differently when added to your page based on inheritance from some styles.', 'logoshowcase'); ?></span></div>

</div><!-- end .wrap -->
