<?php
/**
  * Plugin Name: Real User Monitoring
  * Plugin URI: http://monitis.com
  * Description: The Real User Monitoring (RUM) is WEB service that provides monitoring for WEB pages based on actual user information such as performance data and statistics.
  * Version: 3.0.3
  * Author: Monitis Inc.
  * Author URI: http://monitis.com
  * License: Apache License, Version 2.0
  */
 
//hooks
add_action('admin_init', 'rum_init');
add_action('admin_menu', 'rum_menu');
add_action('wp_head', 'rum_head');

function rum_init() {
	register_setting('rum_settings_group', 'rum_options');

	add_settings_section('rum_section_options', 'RUM settings', null, 'rum_plugin.php');
	
	add_settings_field('user_id', 'User Id:', 'rum_field_user_id', 'rum_plugin.php', 'rum_section_options');
	add_settings_field('is_active', 'Enable Script', 'rum_field_is_active', 'rum_plugin.php', 'rum_section_options');
	add_settings_field('', '', 'rum_field_save', 'rum_plugin.php', 'rum_section_options');
}

function rum_menu() {
	add_submenu_page( 'options-general.php', 'RUM', 'RUM',  'manage_options', 'rum', 'rum_options');
}

function rum_field_user_id() {
	$options = get_option('rum_options');
	echo '<input id="user_id" name="rum_options[user_id]" size="40" type="text" value="' . $options['user_id'] . '" />';
}

function rum_field_is_active() {
	$options = get_option('rum_options');
	echo '<input name="rum_options[is_active]" id="is_active" type="checkbox" value="1" class="code" ' . checked( 1, $options['is_active'], false ) . ' />';
}

function rum_field_save() {
	echo '<input class="button action" type="submit" value="Save"/>';
}

function rum_options() {
	if (!current_user_can('manage_options')) {
		wp_die(__('You do not have sufficient permissions to access this page.'));
	}

	echo '<div class="wrap">';
		echo '<form method="post" action="options.php">';
			settings_fields('rum_settings_group');
			do_settings_sections('rum_plugin.php');
		echo '</form>';
	echo '</div>';
}

function rum_head() {
	$rum_options = get_option('rum_options');

	if(
		isset($rum_options) &&
		isset($rum_options['is_active']) && $rum_options['is_active'] == 1 &&
		isset($rum_options['user_id']) && $rum_options['user_id'] != ''
	) {
		echo '<script src="//rum.monitis.com/get/jsbenchmark.min.js?id=' . $rum_options['user_id'] . '" type="text/javascript" async="async"></script>';
		echo '<script src="//rum-static.pingdom.net/pa-5aa6c0ce4c40770007000403.js" async></script>';
	} 

}
