<?php if($is_show_analytics): ?>
    <div class="content m-3">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6">
                    <div class="card card-success collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Visitors And Page Views</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Page Title</th>
                                    <th>Active Users</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $visitorsAndPageViews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->pageTitle); ?></td>
                                        <td><?php echo e($row->activeUsers); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-warning collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Visitors And Page Views By Date</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Date</th>
                                    <th>Page Title</th>
                                    <th>Active Users</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $visitorsAndPageViewsByDate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e(date('m-d-Y', strtotime($row->date))); ?></td>
                                        <td><?php echo e($row->pageTitle); ?></td>
                                        <td><?php echo e($row->activeUsers); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-danger collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Total Visitors And Page Views</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Date</th>
                                    <th>Active Users</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $totalVisitorsAndPageViews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e(date('m-d-Y', strtotime($row->date))); ?></td>
                                        <td><?php echo e($row->activeUsers); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-info collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Most Visited Pages</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Page Title</th>
                                    <th>Full Page Url</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $mostVisitedPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->pageTitle); ?></td>
                                        <td><?php echo e($row->fullPageUrl); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-success collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Top Referrers</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Page Referrer</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $topReferrers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->pageReferrer); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-warning collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">User Types</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>New / Returning</th>
                                    <th>Active Users</th>
                                </tr>
                                <?php $__currentLoopData = $userTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->newVsReturning); ?></td>
                                        <td><?php echo e($row->activeUsers); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-danger collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Top Browsers</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Browser</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $topBrowsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->browser); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-info collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Top Countries</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Country</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $topCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->country); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-info collapsed-card">
                        <div class="card-header">
                            <h3 class="card-title">Top Operating Systems</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                    <i class="fas fa-expand"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <tr>
                                    <th>Operating System</th>
                                    <th>Screen Page Views</th>
                                </tr>
                                <?php $__currentLoopData = $topOperatingSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $row = (object) $row;
                                        //dd($row);
                                    ?>
                                    <tr>
                                        <td><?php echo e($row->operatingSystem); ?></td>
                                        <td><?php echo e($row->screenPageViews); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                </div>
                
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php endif; ?>
<?php $__env->startSection('beforeHeadClose'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('beforeBodyClose'); ?>
    <?php if($is_show_analytics): ?>
        <script>
            /* const data = <?php echo $visitorsAndPageViews; ?>;
                            const myChart = new Chart(
                                document.getElementById('visitorsAndPageViews'), {
                                    type: 'bar',
                                    data: {
                                        labels: data.map(row => row.pageTitle),
                                        datasets: [{
                                            type: 'bar',
                                            label: 'Active Users',
                                            data: data.map(row => row.activeUsers)
                                        }, {
                                            type: 'bar',
                                            label: 'Screen Page views',
                                            data: data.map(row => row.screenPageViews)
                                        }]
                                    }
                                }
                            ); */
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/catalyst/site_files/resources/views/back/dashboard/google_analytics.blade.php ENDPATH**/ ?>