@extends('front.layout.app')
@section('content')
    
<!-- Breadcrumbs start -->
<section class="breadcrumbs-wrap">
    <div class="container">
        <h1>{!! cms_page_heading('Services') !!}</h1>
    </div>
</section>
<!-- Breadcrumbs end -->

<main id="main">
    <section class="pagecontent-wrap">
        <div class="container">
            <div class="service-details">
                <div class="row">

                    <!-- Service Detail -->
                    <div class="col-lg-8">
                        <div class="serviceImg mb-4">
                            @if (!empty($serviceObj->icon_image) && file_exists(storage_uploads('services/' . $serviceObj->icon_image)))
                                <img src="{{ asset_uploads('services/' . $serviceObj->icon_image) }}" alt="{{ $serviceObj->icon_image_alt }}">
                            @elseif (!empty($serviceObj->mlstore_image) && file_exists(storage_uploads('mlstore/' . $serviceObj->mlstore_image)))
                                <img src="{{ asset_uploads('mlstore/' . $serviceObj->mlstore_image) }}" alt="{{ $serviceObj->title }}">
                            @else
                                <img src="{{ asset('mlstorage/front/images/noimage.jpg') }}" alt="{{ $serviceObj->title }}">
                            @endif
                        </div>

                        <h2>{{ $serviceObj->title }}</h2>
                        <p>{!! adjustUrl($serviceObj->description) !!}</p>

                        @if(!empty($serviceObj->features))
                            <h3>What you get:</h3>
                            <ul class="list">
                                @foreach($serviceObj->features as $feature)
                                    <li>{{ $feature }}</li>
                                @endforeach
                            </ul>
                        @endif

                        @if(!empty($serviceObj->best_for))
                            <p><strong>Best for:</strong> {!! $serviceObj->best_for !!}</p>
                        @endif
                    </div>

                    <!-- Sidebar -->
                    <div class="col-lg-4">
                        <div class="sticky">
                            <div class="services-card">
                                <p class="services-title">All Services</p>
                                <ul class="list-none">
                                    @foreach ($allServices as $service)
                                        <li class="service-item {{ $service->id == $serviceObj->id ? 'active' : '' }}">
                                            <a href="{{ url('services/' . $service->slug) }}" class="text-decoration-none {{ $service->id == $serviceObj->id ? 'active' : '' }}">
                                                {!! $service->title !!}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                            <div class="phone-section">
                                <div class="phone-icon">
                                    <img src="{{ asset('images/phone-icon.png') }}" alt="">
                                </div>
                                <p class="phone-label">Or Have A Question? Call Us</p>
                                <a href="tel:7701234567" class="phone-number text-decoration-none">(770) 123 4567</a>
                            </div>
                        </div>
                    </div>

                </div> <!-- row end -->
            </div> <!-- service-details end -->
        </div> <!-- container end -->
    </section>
</main>


    @endsection
    @section('beforeHeadClose')
        <style>
            .mb-3px {
                margin-bottom: 3px;
            }
        </style>
    @endsection
    @section('beforeBodyClose')
        <div class="modal fade" id="beforeAfterImageModal" tabindex="-1" aria-labelledby="beforeAfterImageModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-scrollable modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="row text-center" id="beforeAfterImageModalContainer"></div>
                    </div>
                </div>
            </div>
        </div>
        <script>
            function showBeforeAfterModal(image_id, before_image, after_image) {
                var htmlStr = `<img-comparison-slider>
                                    <figure slot="first" class="before">
                                        <img width="100%" src="${before_image}">
                                        <figcaption>Before</figcaption>
                                    </figure>
                                    <figure slot="second" class="after">
                                        <img width="100%" src="${after_image}">
                                        <figcaption>After</figcaption>
                                    </figure>
                                </img-comparison-slider>`;
                $('#beforeAfterImageModalContainer').html(htmlStr);
                $('#beforeAfterImageModal').modal('show');
            }
        </script>
    @endsection


								
							</div>

								</div>
		 		</div>

		 	</div>
		 </section>

		</main>
