@extends('front.layout.app')
@section('beforeHeadClose')
<link href="{{ asset_storage('') . 'module/blog/front/css/blog.css' }}" rel="stylesheet" type="text/css" />
@endsection
@section('content')







<!-- Breadcrumbs start -->
<section class="breadcrumbs-wrap">
    <div class="container">
        <h1>{!! cms_page_heading('Services') !!}</h1>
    </div>
</section>
<!-- Breadcrumbs end -->

<main id="main">
    <section class="pagecontent-wrap">
        <div class="container">
            <div class="core-services nobg p-0">
                <div class="row corewrap g-4">

                    @if (count($allServices) > 0)
                        @foreach ($allServices as $serviceObj)
                            <div class="col-lg-4">
                                <div class="frame">
                                    <div class="serviceImg">
                                      @if (!empty($serviceObj->icon_image) && file_exists(storage_uploads('services/' . $serviceObj->icon_image)))
    <img src="{{ asset_uploads('services/' . $serviceObj->icon_image) }}" alt="{{ $serviceObj->icon_image_alt }}">
@else
    <img src="{{ asset('mlstorage/front/images/noimage.jpg') }}" alt="{{ $serviceObj->title }}">
@endif

                                    </div>
                                    <h3>{!! $serviceObj->title !!}</h3>
                                    <p>{!! Str::limit(strip_tags($serviceObj->description), 200, '...') !!}</p>
                                    <a href="{{ url('services/' . $serviceObj->slug) }}" class="read-more">Read More</a>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <p style="text-align:center;">No Record Found</p>
                    @endif

                </div>
            </div>
        </div>
    </section>
</main>


    @endsection
    @section('beforeHeadClose')
        <style>
            .mb-3px {
                margin-bottom: 3px;
            }
        </style>
    @endsection
    @section('beforeBodyClose')
        <div class="modal fade" id="beforeAfterImageModal" tabindex="-1" aria-labelledby="beforeAfterImageModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-scrollable modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="row text-center" id="beforeAfterImageModalContainer"></div>
                    </div>
                </div>
            </div>
        </div>
        <script>
            function showBeforeAfterModal(image_id, before_image, after_image) {
                var htmlStr = `<img-comparison-slider>
                                    <figure slot="first" class="before">
                                        <img width="100%" src="${before_image}">
                                        <figcaption>Before</figcaption>
                                    </figure>
                                    <figure slot="second" class="after">
                                        <img width="100%" src="${after_image}">
                                        <figcaption>After</figcaption>
                                    </figure>
                                </img-comparison-slider>`;
                $('#beforeAfterImageModalContainer').html(htmlStr);
                $('#beforeAfterImageModal').modal('show');
            }
        </script>
    @endsection


								
							</div>

								</div>
		 		</div>

		 	</div>
		 </section>

		</main>





