@extends('front.layout.app')
@section('beforeHeadClose')
<link href="{{ asset_storage('') . 'module/blog/front/css/blog.css' }}" rel="stylesheet" type="text/css" />
@endsection
@section('content')
<?php $settingInformation = settingArr(); ?>
@php echo cms_edit_page("blog",$blog_post_details->id);@endphp

<!-- Breadcrumbs start -->
<section class="breadcrumbs-wrap">
    <div class="container">
        <h1>{!! cms_page_heading($blog_post_details->title) !!}</h1>
    </div>
</section>
<!-- Breadcrumbs end -->
<main id="main">

<section class="pagecontent-wrap">
    <div class="container">

        <div class="service-details">
            <div class="row">

                <!-- Blog Detail Section -->
                <div class="col-lg-8">
                    <div class="serviceImg mb-4">
                        @if (!empty($blog_post_details->featured_img) && file_exists(storage_uploads('blog/' . $blog_post_details->featured_img)))
                            <img 
                                src="{{ asset_uploads('blog/' . $blog_post_details->featured_img) }}"
                                title="{{ $blog_post_details->featured_img_title }}"
                                alt="{{ $blog_post_details->featured_img_alt }}">
                        @else
                            <img 
                                src="{{ asset_uploads('back/images/no_image.jpg') }}"
                                title="{{ $blog_post_details->featured_img_title }}"
                                alt="{{ $blog_post_details->featured_img_alt }}">
                        @endif

                        <div class="dateblog">
                            {{ date('F d, Y', strtotime($blog_post_details['dated'])) }}
                        </div>
                    </div>

                    <h2>{{ $blog_post_details->title }}</h2>

                    <div class="blog-description">
                        {!! $blog_post_details->description !!}
                    </div>

                    <div class="mt-5 text-center">
                        <a href="{{ url()->previous() }}" class="btn btn-primary px-4">
                            Back to Insights
                        </a>
                    </div>
                </div>
                <!-- End Blog Detail Section -->


                <!-- Sidebar Section -->
                <div class="col-lg-4">
                    <div class="sticky">

                        <div class="services-card mb-4">
                            <p class="services-title">All Blogs</p>
                            <ul class="list-none">
                                @foreach ($blogData->take(4) as $blogsValues)
                                    <li class="service-item">
                                        <a href="{{ url('blog/' . $blogsValues->post_slug) }}" class="text-decoration-none">
                                            {!! $blogsValues->title !!}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                        <div class="phone-section">
                            <div class="phone-icon">
                                <img src="{{ asset('mlstorage/front/images/phone-icon.png') }}" alt="Phone Icon">
                            </div>
                            <p class="phone-label">Or Have A Question? Call Us</p>
                            <a href="tel:{{ $settingInformation['telephone'] }}" class="phone-number text-decoration-none">
                                {{ $settingInformation['telephone'] }}
                            </a>
                        </div>

                    </div>
                </div>
                <!-- End Sidebar Section -->

            </div>
        </div>

    </div>
</section>


</main>
@endsection