@extends('front.layout.app')
@section('beforeHeadClose')
    <link href="{{ asset_storage('') . 'module/blog/front/css/blog.css' }}" rel="stylesheet" type="text/css" />
@endsection
@section('content')
    @php echo cms_edit_page("blog");@endphp

  		<!-- Breadcrumbs start -->
		 <section class="breadcrumbs-wrap">
		 	<div class="container">
		 		<h1> {!! cms_page_heading('Blog') !!}</h1>
		 	</div>
		 </section>
		<!-- Breadcrumbs end --> 
		<main id="main">
<section class="pagecontent-wrap">
    <div class="container">
        <div class="core-services insights-wrap nobg p-0">
            <div class="row corewrap g-4">

                @if (count($blogData) > 0)
                    @foreach ($blogData as $blogsValues)
                        <div class="col-lg-4">
                       <div class="frame">
    <div class="serviceImg">
        @if (!empty($blogsValues['featured_img']) && file_exists(storage_uploads('blog/' . $blogsValues['featured_img'])))
            <img src="{{ asset_uploads('blog/' . $blogsValues['featured_img']) }}" alt="{{ $blogsValues['featured_img_alt'] }}">
        @else
            <img src="{{ $blogsValues['featured_img_title'] }}" alt="{{ $blogsValues['featured_img_alt'] }}">
        @endif
        <div class="dateblog">{{ date('M d, Y', strtotime($blogsValues['dated'])) }}</div>
    </div>

    <h3>
        <a href="{{ base_url() . 'blog/' . $blogsValues['post_slug'] }}">
            {!! $blogsValues['title'] !!}
        </a>
    </h3>

    <p>{{ Str::limit(strip_tags($blogsValues['description']), 180, '...') }}</p>

    <a href="{{ base_url() . 'blog/' . $blogsValues['post_slug'] }}" class="read-more">
        Read More
    </a>
</div>

                        </div>
                    @endforeach
                @endif

            </div>
        </div>
    </div>
</section>




		</main>


@endsection
